/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.rmi.RemoteException;
import java.util.List;
import org.glite.security.voms.VOMSException;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.groups.ListMemberNamesOperation;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.error.NoSuchRoleException;
import org.glite.security.voms.admin.service.ServiceExceptionHelper;
import org.glite.security.voms.admin.service.ServiceUtils;
import org.glite.security.voms.service.compatibility.VOMSCompatibility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VomsCompatibilityService
implements VOMSCompatibility {
    private static final Logger log = LoggerFactory.getLogger(VomsCompatibilityService.class);

    @Override
    public int getMajorVersionNumber() throws RemoteException {
        return 2;
    }

    @Override
    public int getMinorVersionNumber() throws RemoteException {
        return 0;
    }

    @Override
    public int getPatchVersionNumber() throws RemoteException {
        return 0;
    }

    @Override
    public String[] getGridmapUsers() throws RemoteException, VOMSException {
        log.info("getGridmapUsers();");
        try {
            String voName = VOMSConfiguration.instance().getVOName();
            List<String> members = (List<String>)ListMemberNamesOperation.instance("/" + voName).execute();
            if (VOMSConfiguration.instance().getBoolean("voms.mkgridmap.translate_dn_email_format", false)) {
                members = ServiceUtils.decorateDNList(members);
            }
            return ServiceUtils.toStringArray(members);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public String[] getGridmapUsers(String container) throws RemoteException, VOMSException {
        log.info("getGridmapUsers(" + container + ");");
        try {
            List<String> members = (List<String>)ListMemberNamesOperation.instance(container).execute();
            if (VOMSConfiguration.instance().getBoolean("voms.mkgridmap.translate_dn_email_format", false)) {
                members = ServiceUtils.decorateDNList(members);
            }
            return ServiceUtils.toStringArray(members);
        }
        catch (NoSuchRoleException e) {
            log.warn("Role '{}' is not defined for this VO.", (Object)container);
            return null;
        }
        catch (NoSuchGroupException e) {
            log.warn("Group '{}' is not defined for this VO.", (Object)container);
            return null;
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }
}

