/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.util.regex.Pattern;
import org.glite.security.voms.User;

public class Validator {
    public static final String VALID_INPUT_PATTERN = "^[^<>&=]*$";
    public static final String VALID_DN_PATTERN = "^[^<>&]*$";
    public static final Pattern inputPattern = Pattern.compile("^[^<>&=]*$");
    public static final Pattern dnPattern = Pattern.compile("^[^<>&]*$");

    public static void validateInputString(String inputString, String errorMessage) {
        assert (inputString != null) : "Cannot validate a null input string!";
        if (!inputPattern.matcher(inputString).matches()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void validateDN(String dnString, String errorMessage) {
        assert (dnString != null) : "Cannot validate a null input string!";
        if (!dnPattern.matcher(dnString).matches()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void validateUser(User u) {
        Validator.validateDN(u.getDN(), "Invalid characters in user's DN!");
        if (u.getCN() != null) {
            Validator.validateDN(u.getCN(), "Invalid characters in user's CN!");
        }
        if (u.getMail() != null) {
            Validator.validateDN(u.getMail(), "Invalid characters in user's EMAIL!");
        }
    }
}

