/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.glite.security.voms.VOMSException;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.notification.VOMSNotificationException;
import org.glite.security.voms.admin.notification.messages.ConfirmRequest;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.persistence.dao.RequestDAO;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.model.VOMembershipRequest;
import org.glite.security.voms.admin.service.ServiceExceptionHelper;
import org.glite.security.voms.admin.service.ServiceUtils;
import org.glite.security.voms.admin.util.DNUtil;
import org.glite.security.voms.service.registration.RegistrationRequest;
import org.glite.security.voms.service.registration.VOMSRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSRegistrationService
implements VOMSRegistration {
    private static final Logger log = LoggerFactory.getLogger(VOMSRegistrationService.class);

    private String buildConfirmURL(HttpServletRequest request, VOMembershipRequest membReq) {
        return ServiceUtils.getBaseContext(request) + "/ConfirmVOMembershipRequest.do?requestId=" + membReq.getId() + "&confirmId=" + membReq.getConfirmId();
    }

    private String buildCancelURL(HttpServletRequest request, VOMembershipRequest membReq) {
        return ServiceUtils.getBaseContext(request) + "/CancelVOMembershipRequest.do?requestId=" + membReq.getId() + "&confirmId=" + membReq.getConfirmId();
    }

    @Override
    public void submitRegistrationRequest(RegistrationRequest request) throws RemoteException, VOMSException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (request == null) {
                throw new NullArgumentException("Cannot submit a null request!");
            }
            CurrentAdmin admin = CurrentAdmin.instance();
            VOMembershipRequest req = RequestDAO.instance().findPendingForUser(admin.getRealSubject(), admin.getRealIssuer());
            if (req != null) {
                throw new AlreadyExistsException("A registration pending for user '" + admin.getRealSubject() + "' has already been received. " + "Follow the instructions that were communicated to complete registration.");
            }
            req = RequestDAO.instance().createFromAdmin(request.getEmailAddress());
            String confirmURL = this.buildConfirmURL(httpServletRequest, req);
            String cancelURL = this.buildCancelURL(httpServletRequest, req);
            ConfirmRequest n = new ConfirmRequest(request.getEmailAddress(), confirmURL, cancelURL);
            try {
                n.send();
            }
            catch (VOMSNotificationException e) {
                log.error("Error sending notification for request!", (Throwable)e);
                log.error("Request will be discarded.");
                RequestDAO.instance().delete(req);
            }
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public void submitRegistrationRequestForUser(String userSubject, String caSubject, RegistrationRequest request) throws RemoteException, VOMSException {
        try {
            HttpServletRequest httpServletRequest = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            if (request == null) {
                throw new NullArgumentException("Cannot submit a null request!");
            }
            if (userSubject == null) {
                throw new NullArgumentException("Cannot submit a request for a null user!");
            }
            if (caSubject == null) {
                throw new NullArgumentException("Cannot submit a request for a null CA!");
            }
            String normalizedSubject = DNUtil.normalizeDN(userSubject);
            String normalizedCASubject = DNUtil.normalizeDN(caSubject);
            VOMembershipRequest req = RequestDAO.instance().findPendingForUser(normalizedSubject, normalizedCASubject);
            if (req != null) {
                throw new AlreadyExistsException("A registration pending for user '" + normalizedSubject + "' has already been received. " + "Follow the instructions that were communicated to complete registration.");
            }
            req = RequestDAO.instance().createFromDNCA(normalizedSubject, normalizedCASubject, request.getEmailAddress());
            String confirmURL = this.buildConfirmURL(httpServletRequest, req);
            String cancelURL = this.buildCancelURL(httpServletRequest, req);
            ConfirmRequest n = new ConfirmRequest(request.getEmailAddress(), confirmURL, cancelURL);
            try {
                n.send();
            }
            catch (VOMSNotificationException e) {
                log.error("Error sending notification for request!", (Throwable)e);
                log.error("Request will be discarded.");
                RequestDAO.instance().delete(req);
            }
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }
}

