/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.service;

import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.users.AddUserCertificateOperation;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.admin.operations.users.RemoveUserCertificateOperation;
import org.glite.security.voms.admin.operations.users.RestoreUserCertificateOperation;
import org.glite.security.voms.admin.operations.users.SuspendUserCertificateOperation;
import org.glite.security.voms.admin.persistence.error.NoSuchUserException;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.service.ServiceExceptionHelper;
import org.glite.security.voms.admin.service.ServiceUtils;
import org.glite.security.voms.service.certificates.VOMSCertificates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSCertificatesService
implements VOMSCertificates {
    private static final Logger log = LoggerFactory.getLogger(VOMSCertificatesService.class);

    @Override
    public void addCertificate(long userId, org.glite.security.voms.service.certificates.X509Certificate cert) throws RemoteException {
        try {
            if (cert == null) {
                throw new NullArgumentException("X509Certificate cannot be null!");
            }
            if (userId < 0L) {
                throw new IllegalArgumentException("the userId must be a positive integer!");
            }
            VOMSUser user = (VOMSUser)FindUserOperation.instance(userId).execute();
            if (cert.getBytes() != null) {
                X509Certificate x509Cert = ServiceUtils.certificateFromBytes(cert.getBytes());
                AddUserCertificateOperation.instance(user, x509Cert).execute();
            } else {
                AddUserCertificateOperation.instance(user, cert.getSubject(), cert.getIssuer(), cert.getNotAfter()).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public org.glite.security.voms.service.certificates.X509Certificate[] getCertificates(long userId) throws RemoteException {
        try {
            VOMSUser u = (VOMSUser)FindUserOperation.instance(userId).execute();
            return ServiceUtils.toX509CertificateArray(u.getCertificates());
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public org.glite.security.voms.service.certificates.X509Certificate[] getCertificates(String subject, String issuer) throws RemoteException {
        try {
            VOMSUser u = (VOMSUser)FindUserOperation.instance(subject, issuer).execute();
            if (u == null) {
                throw new NoSuchUserException(String.format("No '%s,%s' user found in this VO", subject, issuer));
            }
            return ServiceUtils.toX509CertificateArray(u.getCertificates());
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public long getUserIdFromDn(String subject, String issuer) throws RemoteException {
        try {
            if (subject == null) {
                throw new NullArgumentException("User's subject cannot be null!");
            }
            if (issuer == null) {
                throw new NullArgumentException("User's issuer cannot be null!");
            }
            VOMSUser u = (VOMSUser)FindUserOperation.instance(subject, issuer).execute();
            if (u == null) {
                return -1L;
            }
            return u.getId();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public void addCertificate(String registeredCertSubject, String registeredCertIssuer, org.glite.security.voms.service.certificates.X509Certificate cert) throws RemoteException {
        try {
            long userId = this.getUserIdFromDn(registeredCertSubject, registeredCertIssuer);
            this.addCertificate(userId, cert);
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public void removeCertificate(org.glite.security.voms.service.certificates.X509Certificate cert) throws RemoteException {
        try {
            if (cert.getBytes() != null) {
                X509Certificate x509Cert = ServiceUtils.certificateFromBytes(cert.getBytes());
                RemoveUserCertificateOperation.instance(x509Cert).execute();
            } else {
                RemoveUserCertificateOperation.instance(cert.getSubject(), cert.getIssuer()).execute();
            }
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public void suspendCertificate(org.glite.security.voms.service.certificates.X509Certificate cert, String reason) throws RemoteException {
        try {
            SuspendUserCertificateOperation.instance(cert.getSubject(), cert.getIssuer(), reason).execute();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }

    @Override
    public void restoreCertificate(org.glite.security.voms.service.certificates.X509Certificate cert) throws RemoteException {
        try {
            RestoreUserCertificateOperation.instance(cert.getSubject(), cert.getIssuer()).execute();
        }
        catch (RuntimeException e) {
            ServiceExceptionHelper.handleServiceException(log, e);
            throw e;
        }
    }
}

