/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model.task;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.glite.security.voms.admin.persistence.model.task.Task;

@Entity
@Table(name="task_log_record")
public class LogRecord
implements Serializable,
Comparable<LogRecord> {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="VOMS_TASK_LR_SEQ")
    @SequenceGenerator(name="VOMS_TASK_LR_SEQ", sequenceName="VOMS_TASK_LR_SEQ")
    Long id;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    Task.TaskStatus event;
    @Column(nullable=false, name="creation_time")
    Date date;
    @ManyToOne
    @JoinColumn(name="task_id", nullable=false)
    Task task;
    String adminDn;
    String userDn;

    public Long getId() {
        return this.id;
    }

    public Task.TaskStatus getEvent() {
        return this.event;
    }

    public Date getDate() {
        return this.date;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setEvent(Task.TaskStatus event) {
        this.event = event;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public int compareTo(LogRecord o) {
        return new CompareToBuilder().append((Object)this.task, (Object)o.task).append((Object)this.date, (Object)o.date).append((Object)this.event, (Object)o.event).toComparison();
    }

    public Task getTask() {
        return this.task;
    }

    public void setTask(Task task) {
        this.task = task;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogRecord)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        LogRecord that = (LogRecord)other;
        EqualsBuilder builder = new EqualsBuilder();
        return builder.append((Object)this.task, (Object)that.task).append((Object)this.date, (Object)that.date).append((Object)this.event, (Object)that.event).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 35).append((Object)this.task).append((Object)this.date).append((Object)this.event).toHashCode();
    }

    public String getAdminDn() {
        return this.adminDn;
    }

    public void setAdminDn(String adminDn) {
        this.adminDn = adminDn;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String userDn) {
        this.userDn = userDn;
    }
}

