/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model.request;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

@Entity
@Table(name="requester_info")
public class RequesterInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MULTIVALUE_COUNT_PREFIX = "num_";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="VOMS_REQ_INFO_SEQ")
    @SequenceGenerator(name="VOMS_REQ_INFO_SEQ", sequenceName="VOMS_REQ_INFO_SEQ")
    Long id;
    @Column(nullable=false)
    String certificateSubject;
    @Column(nullable=false)
    String certificateIssuer;
    String name;
    String surname;
    String institution;
    String address;
    String phoneNumber;
    @Column(nullable=false)
    String emailAddress;
    @CollectionOfElements
    @JoinTable(name="requester_personal_info", joinColumns={@JoinColumn(name="requester_id")})
    @MapKey(columns={@Column(name="pi_key")})
    @Column(name="pi_value")
    Map<String, String> personalInformation = new HashMap<String, String>();
    Boolean voMember;

    public Long getId() {
        return this.id;
    }

    public String getCertificateSubject() {
        return this.certificateSubject;
    }

    public String getCertificateIssuer() {
        return this.certificateIssuer;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCertificateSubject(String certificateSubject) {
        this.certificateSubject = certificateSubject;
    }

    public void setCertificateIssuer(String certificateIssuer) {
        this.certificateIssuer = certificateIssuer;
    }

    public Map<String, String> getPersonalInformation() {
        return this.personalInformation;
    }

    public void setPersonalInformation(Map<String, String> personalInformation) {
        this.personalInformation = personalInformation;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public boolean isVoMember() {
        return this.voMember;
    }

    public Boolean getVoMember() {
        return this.voMember;
    }

    public void setVoMember(Boolean voMember) {
        this.voMember = voMember;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RequesterInfo)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        RequesterInfo that = (RequesterInfo)other;
        return new EqualsBuilder().append((Object)this.certificateSubject, (Object)that.certificateSubject).append((Object)this.certificateIssuer, (Object)that.certificateIssuer).append((Object)this.emailAddress, (Object)that.emailAddress).isEquals();
    }

    public String addInfo(String name, String value) {
        return this.personalInformation.put(name, value);
    }

    public String getInfo(String name) {
        return this.personalInformation.get(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.certificateSubject).append((Object)this.certificateIssuer).append((Object)this.emailAddress).toHashCode();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("certificateSubject", (Object)this.certificateSubject).append("certificateIssuer", (Object)this.certificateIssuer).append("emailAddress", (Object)this.emailAddress).append("name", (Object)this.name).append("surname", (Object)this.surname).append("voMember", (Object)this.voMember);
        return builder.toString();
    }

    public List<String> getMultivaluedInfo(String propertyName) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.personalInformation.get(MULTIVALUE_COUNT_PREFIX + propertyName) != null) {
            Integer valueCount = Integer.parseInt(this.personalInformation.get(MULTIVALUE_COUNT_PREFIX + propertyName));
            for (int i = 0; i < valueCount; ++i) {
                result.add(this.personalInformation.get(propertyName + i));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public static RequesterInfo fromVOUser(VOMSUser user) {
        RequesterInfo ri = new RequesterInfo();
        ri.setName(user.getName());
        ri.setSurname(user.getSurname());
        ri.setAddress(user.getAddress());
        ri.setInstitution(user.getInstitution());
        ri.setPhoneNumber(user.getPhoneNumber());
        ri.setEmailAddress(user.getEmailAddress());
        ri.setCertificateSubject(user.getDefaultCertificate().getSubjectString());
        ri.setCertificateIssuer(user.getDefaultCertificate().getCa().getSubjectString());
        ri.setVoMember(true);
        return ri;
    }
}

