/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model.request;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.persistence.model.NamedType;
import org.glite.security.voms.admin.persistence.model.request.RequesterInfo;

@Entity
@Table(name="req")
@Inheritance(strategy=InheritanceType.JOINED)
public abstract class Request
implements Serializable,
NamedType {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="VOMS_REQ_SEQ")
    @SequenceGenerator(name="VOMS_REQ_SEQ", sequenceName="VOMS_REQ_SEQ")
    @Column(name="request_id")
    Long id;
    Date creationDate;
    Date expirationDate;
    Date completionDate;
    @OneToOne(optional=false, cascade={CascadeType.ALL})
    @JoinColumn(name="requester_info_id", nullable=false, updatable=false)
    RequesterInfo requesterInfo;
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    STATUS status;

    public Long getId() {
        return this.id;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public Date getCompletionDate() {
        return this.completionDate;
    }

    public RequesterInfo getRequesterInfo() {
        return this.requesterInfo;
    }

    public STATUS getStatus() {
        return this.status;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setCompletionDate(Date completionDate) {
        this.completionDate = completionDate;
    }

    public void setRequesterInfo(RequesterInfo requesterInfo) {
        this.requesterInfo = requesterInfo;
    }

    public void setStatus(STATUS status) {
        this.status = status;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Request)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        Request that = (Request)other;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.creationDate, (Object)that.creationDate).append((Object)this.requesterInfo, (Object)that.requesterInfo).append((Object)this.status, (Object)that.status).append((Object)this.completionDate, (Object)that.completionDate).append((Object)this.expirationDate, (Object)that.expirationDate);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder(17, 37);
        builder.append((Object)this.creationDate).append((Object)this.requesterInfo).append((Object)this.status).append((Object)this.completionDate).append((Object)this.expirationDate);
        return builder.toHashCode();
    }

    public void approve() {
        this.setStatus(STATUS.APPROVED);
        this.setCompletionDate(new Date());
    }

    public void reject() {
        this.setStatus(STATUS.REJECTED);
        this.setCompletionDate(new Date());
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("id", (Object)this.id).append("status", (Object)this.status).append("requesterInfo", (Object)this.requesterInfo).append("creationDate", (Object)this.creationDate).append("expirationDate", (Object)this.expirationDate).append("completionDate", (Object)this.completionDate);
        return builder.toString();
    }

    public static enum STATUS {
        SUBMITTED,
        CONFIRMED,
        PENDING,
        APPROVED,
        REJECTED;

    }
}

