/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import org.glite.security.voms.admin.error.IllegalStateException;
import org.glite.security.voms.admin.persistence.Auditable;
import org.glite.security.voms.admin.persistence.model.VOMSCapability;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSMapping
implements Serializable,
Auditable,
Comparable {
    private static final Logger log = LoggerFactory.getLogger(VOMSMapping.class);
    private static final long serialVersionUID = 1L;
    private Long id;
    private VOMSUser user;
    private VOMSGroup group;
    private VOMSRole role;
    private VOMSCapability capability = null;

    public VOMSMapping() {
    }

    public VOMSMapping(VOMSUser u, VOMSGroup g, VOMSRole r) {
        this.user = u;
        this.group = g;
        this.role = r;
    }

    public static VOMSMapping instance(VOMSUser u, VOMSGroup g, VOMSRole r) {
        VOMSMapping m = new VOMSMapping(u, g, r);
        return m;
    }

    public static VOMSMapping instance(VOMSUser u, VOMSGroup g) {
        return VOMSMapping.instance(u, g, null);
    }

    public VOMSCapability getCapability() {
        return this.capability;
    }

    public void setCapability(VOMSCapability capability) {
        this.capability = capability;
    }

    public VOMSGroup getGroup() {
        return this.group;
    }

    public void setGroup(VOMSGroup group) {
        this.group = group;
    }

    public VOMSRole getRole() {
        return this.role;
    }

    public void setRole(VOMSRole role) {
        this.role = role;
    }

    public VOMSUser getUser() {
        return this.user;
    }

    public void setUser(VOMSUser user) {
        this.user = user;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean equals(Object other) {
        log.debug("Comparing mappings for EQUALITY. this=" + this + ", other=" + other);
        if (this == other) {
            log.debug("Same object, will return true");
            return true;
        }
        if (!(other instanceof VOMSMapping)) {
            log.debug("The other is not a VOMSMapping, will return false.");
            return false;
        }
        if (other == null) {
            log.debug("The other is null, returning false");
            return false;
        }
        VOMSMapping that = (VOMSMapping)other;
        if (!this.getUser().equals(that.getUser())) {
            log.debug("Different users, will return false.");
            return false;
        }
        if (this.isGroupMapping() && that.isGroupMapping()) {
            log.debug("Both group mappings");
            boolean result = this.getGroup().equals(that.getGroup());
            log.debug("Will return: " + result);
            return result;
        }
        if (this.isRoleMapping() && that.isRoleMapping()) {
            log.debug("Both role mappings");
            boolean result = this.getGroup().equals(that.getGroup()) && this.getRole().equals(that.getRole());
            log.debug("Will return: " + result);
            return result;
        }
        log.debug("Incompatible mappings.");
        log.debug("Will return: false as equality result.");
        return false;
    }

    public boolean isGroupMapping() {
        if (this.getUser() == null) {
            throw new IllegalStateException("This mapping has not been initialized (user== null)!");
        }
        if (this.getGroup() == null) {
            throw new IllegalStateException("This mapping has not been initialized (group == null)!");
        }
        return this.getRole() == null;
    }

    public boolean isRoleMapping() {
        if (this.getUser() == null) {
            throw new IllegalStateException("This mapping has not been initialized (user== null)!");
        }
        if (this.getGroup() == null) {
            throw new IllegalStateException("This mapping has not been initialized (group == null)!");
        }
        return this.getRole() != null;
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + this.getUser().hashCode();
        result = 29 * result + this.getGroup().hashCode();
        if (this.getRole() != null) {
            result = 29 * result + this.getRole().hashCode();
        }
        if (this.getCapability() != null) {
            result = 29 * result + this.getCapability().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getUser() != null) {
            buf.append(this.getUser() + ",");
        }
        buf.append(this.getFQAN());
        return buf.toString();
    }

    public String getFQAN() {
        StringBuffer buf = new StringBuffer();
        if (this.getGroup() != null) {
            buf.append(this.getGroup());
        }
        if (this.getRole() != null) {
            buf.append("/" + this.getRole());
        }
        return buf.toString();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        log.debug("Comparing mappings. this=" + this + ", other=" + o);
        VOMSMapping that = (VOMSMapping)o;
        if (!this.getUser().equals(that.getUser())) {
            log.debug("Different users.");
            int result = this.getUser().compareTo(that.getUser());
            log.debug("Will return " + result);
            return result;
        }
        if (this.isGroupMapping() && that.isGroupMapping()) {
            log.debug("Both group mappings");
            int result = this.getGroup().compareTo(that.getGroup());
            log.debug("Will return: " + result);
            return result;
        }
        if (this.isRoleMapping() && that.isRoleMapping()) {
            int result;
            log.debug("Both role mappings");
            int groupResult = this.getGroup().compareTo(that.getGroup());
            if (groupResult == 0) {
                log.debug("Roles in the same group, check role name");
                result = this.getRole().compareTo(that.getRole());
            } else {
                log.debug("Roles in different groups, the group name is enough.");
                result = groupResult;
            }
            log.debug("Will return: " + result);
            return result;
        }
        log.debug("One is a role, one is a group, will sort against groups.");
        if (this.isGroupMapping() && that.isRoleMapping()) {
            int result;
            log.debug("This group, that role");
            int groupResult = this.getGroup().compareTo(that.getGroup());
            if (groupResult == 0) {
                log.debug("Same group, group mappings comes first.");
                result = -1;
            } else {
                log.debug("Different groups, using group sorting.");
                result = groupResult;
            }
            log.debug("Will return: " + result);
            return result;
        }
        if (this.isRoleMapping() && that.isGroupMapping()) {
            int result;
            log.debug("This role, that group");
            int groupResult = this.getGroup().compareTo(that.getGroup());
            if (groupResult == 0) {
                log.debug("Same group, group mappings comes first.");
                result = 1;
            } else {
                log.debug("Different groups, using group sorting.");
                result = groupResult;
            }
            log.debug("Will return: " + result);
            return result;
        }
        int result = 1;
        log.debug("Unhandled situation. THIS IS A BUG!!!!!! FIXMEEEEE!!!");
        log.debug("Will return: " + result);
        return result;
    }
}

