/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.glite.security.voms.admin.persistence.Auditable;
import org.glite.security.voms.admin.persistence.error.NoSuchAttributeException;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.TagMapping;
import org.glite.security.voms.admin.persistence.model.VOMSGroupAttribute;
import org.glite.security.voms.admin.persistence.model.VOMSMapping;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSGroup
implements Serializable,
Auditable,
Comparable {
    public static final Logger log = LoggerFactory.getLogger(VOMSGroup.class);
    private static final long serialVersionUID = -4693441755811017977L;
    Long id;
    String name;
    VOMSGroup parent;
    Boolean must;
    Set attributes = new HashSet();
    Set mappings = new TreeSet();
    Set acls = new HashSet();
    Set<TagMapping> tagMappings = new HashSet<TagMapping>();
    Boolean restricted;
    String description;

    public VOMSGroup() {
        this.must = new Boolean(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Boolean getMust() {
        return this.must;
    }

    public void setMust(Boolean must) {
        this.must = must;
    }

    public VOMSGroup getParent() {
        return this.parent;
    }

    public void setParent(VOMSGroup parent) {
        this.parent = parent;
    }

    public Set getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Set attributes) {
        this.attributes = attributes;
    }

    public boolean isRootGroup() {
        return this.equals(this.parent);
    }

    public void addAttribute(VOMSGroupAttribute val) {
        this.attributes.add(val);
    }

    public VOMSGroupAttribute getAttributeByName(String name) {
        for (VOMSGroupAttribute tmp : this.attributes) {
            if (!tmp.getName().equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public void deleteAttribute(VOMSGroupAttribute val) {
        if (!this.attributes.contains(val)) {
            throw new NoSuchAttributeException("Attribute \"" + val.getName() + "\" undefined for group" + this);
        }
        this.attributes.remove(val);
    }

    public void deleteAttributeByName(String attrName) {
        this.deleteAttribute(this.getAttributeByName(attrName));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VOMSGroup)) {
            return false;
        }
        VOMSGroup that = (VOMSGroup)other;
        if (that == null) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public boolean hasMember(VOMSUser u) {
        VOMSMapping m = new VOMSMapping(u, this, null);
        return this.mappings.contains(m);
    }

    public Set getMembers() {
        TreeSet<VOMSUser> res = new TreeSet<VOMSUser>();
        for (VOMSMapping m : this.mappings) {
            if (!m.isGroupMapping()) continue;
            res.add(m.getUser());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public Set getMembersEmailAddresses() {
        TreeSet<String> res = new TreeSet<String>();
        for (VOMSMapping m : this.mappings) {
            if (!m.isGroupMapping()) continue;
            res.add(m.getUser().getEmailAddress());
        }
        return Collections.unmodifiableSortedSet(res);
    }

    public boolean isDescendant(VOMSGroup g) {
        return this.name.startsWith(g.getName());
    }

    public Set getMappings() {
        return this.mappings;
    }

    public void setMappings(Set mappings) {
        this.mappings = mappings;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String toString() {
        return this.getName();
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        VOMSGroup that = (VOMSGroup)o;
        if (that == null) {
            return 1;
        }
        return this.getName().compareTo(that.getName());
    }

    public Set getAcls() {
        return this.acls;
    }

    public void setAcls(Set acls) {
        this.acls = acls;
    }

    protected ACL getACL(boolean defaultACL) {
        if (this.getAcls().isEmpty()) {
            return null;
        }
        for (ACL a : this.getAcls()) {
            if (a.getDefaultACL() != defaultACL || !a.getContext().isGroupContext()) continue;
            return a;
        }
        return null;
    }

    public ACL getACL() {
        return this.getACL(false);
    }

    public ACL getDefaultACL() {
        return this.getACL(true);
    }

    public void importACL(ACL acl) {
        ACL importedACL = new ACL(this, false);
        importedACL.getPermissions().putAll(acl.getPermissions());
        this.getAcls().add(importedACL);
    }

    public Set<TagMapping> getTagMappings() {
        return this.tagMappings;
    }

    public void setTagMappings(Set<TagMapping> tagMappings) {
        this.tagMappings = tagMappings;
    }

    public Boolean getRestricted() {
        return this.restricted;
    }

    public void setRestricted(Boolean restricted) {
        this.restricted = restricted;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

