/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.Date;
import org.glite.security.voms.admin.util.DNUtil;

public class VOMSCA
implements Serializable {
    private static final long serialVersionUID = -2633375466574044765L;
    Short id;
    String subjectString;
    String description;
    Date creationTime;

    public VOMSCA() {
    }

    public VOMSCA(X509Certificate cert, String description) {
        assert (cert != null) : "X509Certificate is null!";
        this.subjectString = DNUtil.getOpenSSLSubject(cert.getSubjectX500Principal());
        this.creationTime = new Date();
        this.description = description;
    }

    public VOMSCA(String name, String desc) {
        this.subjectString = name;
        this.description = desc;
        this.creationTime = new Date();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getSubjectString() {
        return this.subjectString;
    }

    public void setSubjectString(String dn) {
        this.subjectString = dn;
    }

    public Short getId() {
        return this.id;
    }

    public void setId(Short id) {
        this.id = id;
    }

    public String toString() {
        return this.subjectString;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VOMSCA)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        VOMSCA that = (VOMSCA)other;
        return this.getSubjectString().equals(that.getSubjectString());
    }

    public int hashCode() {
        return this.subjectString.hashCode();
    }

    public String getShortName() {
        return this.subjectString;
    }

    @Deprecated
    public String getDn() {
        return this.subjectString;
    }

    @Deprecated
    public void setDn(String dn) {
        this.subjectString = dn;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }
}

