/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.persistence.model.Tag;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;

public class TagMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    Long id;
    Tag tag;
    VOMSGroup group;
    VOMSRole role;
    VOMSAdmin admin;

    public TagMapping() {
    }

    public TagMapping(Tag tt, VOMSGroup gg, VOMSRole rr, VOMSAdmin aa) {
        this.tag = tt;
        this.group = gg;
        this.role = rr;
        this.admin = aa;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof TagMapping)) {
            return false;
        }
        TagMapping that = (TagMapping)other;
        if (!this.getTag().equals(that.getTag())) {
            return false;
        }
        if (!this.getGroup().equals(that.getGroup())) {
            return false;
        }
        if (this.getRole() != null && that.getRole() != null) {
            return this.getRole().equals(that.getRole());
        }
        return false;
    }

    public int hashCode() {
        int result = 14;
        result = 29 * result + this.getTag().hashCode();
        result = 29 * result + this.getGroup().hashCode();
        if (this.getRole() != null) {
            result = 29 * result + this.getRole().hashCode();
        }
        return result;
    }

    public VOMSGroup getGroup() {
        return this.group;
    }

    public void setGroup(VOMSGroup group) {
        this.group = group;
    }

    public VOMSRole getRole() {
        return this.role;
    }

    public void setRole(VOMSRole role) {
        this.role = role;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public boolean isGroupMapping() {
        if (this.tag == null) {
            throw new NullArgumentException("tag cannot be null!");
        }
        if (this.group == null) {
            throw new NullArgumentException("group cannot be null!");
        }
        return this.role == null;
    }

    public boolean isRoleMapping() {
        return !this.isGroupMapping();
    }

    public VOMSAdmin getAdmin() {
        return this.admin;
    }

    public void setAdmin(VOMSAdmin admin) {
        this.admin = admin;
    }
}

