/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class AUPAcceptanceRecord
implements Serializable {
    private static final long serialVersionUID = 1L;
    Long id;
    AUPVersion aupVersion;
    VOMSUser user;
    Date lastAcceptanceDate;
    Boolean valid;

    public AUPAcceptanceRecord(VOMSUser u, AUPVersion aup) {
        this.user = u;
        this.aupVersion = aup;
        this.valid = true;
    }

    public AUPAcceptanceRecord() {
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AUPAcceptanceRecord)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        AUPAcceptanceRecord that = (AUPAcceptanceRecord)other;
        return this.getUser().equals(that.getUser()) && this.getAupVersion().equals(that.getAupVersion());
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    public Long getId() {
        return this.id;
    }

    public AUPVersion getAupVersion() {
        return this.aupVersion;
    }

    public VOMSUser getUser() {
        return this.user;
    }

    public Date getLastAcceptanceDate() {
        return this.lastAcceptanceDate;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setAupVersion(AUPVersion aupVersion) {
        this.aupVersion = aupVersion;
    }

    public void setUser(VOMSUser user) {
        this.user = user;
    }

    public void setLastAcceptanceDate(Date lastAcceptanceDate) {
        this.lastAcceptanceDate = lastAcceptanceDate;
    }

    public String toString() {
        return String.format("[user: %s, aupVersion: %s, lastAcceptanceDate: %s, valid: %s]", this.user, this.aupVersion, this.lastAcceptanceDate, this.valid);
    }

    public boolean hasExpired() {
        if (!this.valid.booleanValue()) {
            return true;
        }
        if (this.lastAcceptanceDate.before(this.aupVersion.getLastUpdateTime())) {
            return true;
        }
        Date now = new Date();
        return this.getExpirationDate().before(now);
    }

    public long getDaysSinceLastAcceptance() {
        Date now = new Date();
        long timeDiff = now.getTime() - this.lastAcceptanceDate.getTime();
        return TimeUnit.MILLISECONDS.toDays(timeDiff);
    }

    public long getDaysBeforeExpiration() {
        Date now = new Date();
        if (!this.valid.booleanValue()) {
            return 0L;
        }
        long timeDiff = this.getExpirationDate().getTime() - now.getTime();
        return TimeUnit.MILLISECONDS.toDays(timeDiff);
    }

    public Date getExpirationDate() {
        Calendar c = Calendar.getInstance();
        if (!this.valid.booleanValue()) {
            return c.getTime();
        }
        c.setTime(this.lastAcceptanceDate);
        c.add(6, this.aupVersion.getAup().getReacceptancePeriod());
        return c.getTime();
    }

    public Boolean getValid() {
        return this.valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }
}

