/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.model;

import java.io.Serializable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.glite.security.voms.admin.persistence.error.NoSuchAUPVersionException;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUP
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(AUP.class);
    public static final String VO_AUP_NAME = "VO-AUP";
    public static final String GRID_AUP_NAME = "GRID-AUP";
    Long id;
    String name;
    String description;
    Integer reacceptancePeriod;
    SortedSet<AUPVersion> versions = new TreeSet<AUPVersion>();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AUP)) {
            return false;
        }
        AUP that = (AUP)other;
        if (that == null) {
            return false;
        }
        return that.getName().equals(this.getName());
    }

    public AUPVersion getActiveVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        for (AUPVersion v : this.versions) {
            if (!v.getActive().booleanValue()) continue;
            return v;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public Long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public AUPVersion getOldestVersion() {
        if (this.versions.isEmpty()) {
            return null;
        }
        return this.versions.first();
    }

    public Integer getReacceptancePeriod() {
        return this.reacceptancePeriod;
    }

    public AUPVersion getVersion(String versionNumber) {
        if (this.versions.isEmpty()) {
            return null;
        }
        for (AUPVersion v : this.versions) {
            if (!v.getVersion().equals(versionNumber)) continue;
            return v;
        }
        return null;
    }

    public Set<AUPVersion> getVersions() {
        return this.versions;
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }

    public void setActiveVersion(AUPVersion v) {
        if (this.versions.isEmpty()) {
            throw new NoSuchAUPVersionException("This AUP has no versions defined currently, so you cannot set the 'active' version");
        }
        if (!this.versions.contains(v)) {
            throw new NoSuchAUPVersionException("AUP version '" + v + "' not found among the currently defined versions for this AUP.");
        }
        v.setActive(true);
        for (AUPVersion vv : this.versions) {
            if (vv.equals(v) || !vv.getActive().booleanValue()) continue;
            vv.setActive(false);
        }
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReacceptancePeriod(Integer reacceptancePeriod) {
        this.reacceptancePeriod = reacceptancePeriod;
    }

    public void setVersions(SortedSet<AUPVersion> versions) {
        this.versions = versions;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("id", (Object)this.id).append("name", (Object)this.name).append("description", (Object)this.description).append("reacceptancePeriod", (Object)this.reacceptancePeriod).append("versions", this.versions);
        return builder.toString();
    }
}

