/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao.hibernate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.persistence.dao.generic.RequestDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.GenericHibernateDAO;
import org.glite.security.voms.admin.persistence.error.AlreadyExistsException;
import org.glite.security.voms.admin.persistence.error.AlreadyMemberException;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.CertificateRequest;
import org.glite.security.voms.admin.persistence.model.request.GroupMembershipRequest;
import org.glite.security.voms.admin.persistence.model.request.MembershipRemovalRequest;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;
import org.glite.security.voms.admin.persistence.model.request.Request;
import org.glite.security.voms.admin.persistence.model.request.RequesterInfo;
import org.glite.security.voms.admin.persistence.model.request.RoleMembershipRequest;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;

public class RequestDAOHibernate
extends GenericHibernateDAO<Request, Long>
implements RequestDAO {
    @Override
    public CertificateRequest createCertificateRequest(VOMSUser u, String certificateSubject, String certificateIssuer, Date expirationDate) {
        if (this.userHasPendingCertificateRequest(u, certificateSubject, certificateIssuer)) {
            throw new AlreadyExistsException("User '" + u + "' has a pending certificate request for '" + certificateSubject + "," + certificateIssuer + "',");
        }
        CertificateRequest req = new CertificateRequest();
        req.setStatus(Request.STATUS.SUBMITTED);
        req.setRequesterInfo(RequesterInfo.fromVOUser(u));
        req.setCreationDate(new Date());
        req.setExpirationDate(expirationDate);
        req.setCertificateSubject(certificateSubject);
        req.setCertificateIssuer(certificateIssuer);
        this.makePersistent(req);
        return req;
    }

    @Override
    public GroupMembershipRequest createGroupMembershipRequest(VOMSUser usr, VOMSGroup group, Date expirationDate) {
        if (usr.isMember(group)) {
            throw new VOMSException("User '" + usr + "' is already member of group '" + group + "'!");
        }
        if (this.userHasPendingGroupMembershipRequest(usr, group)) {
            throw new AlreadyMemberException("User '" + usr + "' has a pending group membership request for group '" + group + "'!");
        }
        GroupMembershipRequest req = new GroupMembershipRequest();
        req.setStatus(Request.STATUS.SUBMITTED);
        req.setRequesterInfo(RequesterInfo.fromVOUser(usr));
        req.setCreationDate(new Date());
        req.setExpirationDate(expirationDate);
        req.setGroupName(group.getName());
        this.makePersistent(req);
        return req;
    }

    @Override
    public MembershipRemovalRequest createMembershipRemovalRequest(VOMSUser usr, String reason, Date expirationDate) {
        MembershipRemovalRequest req = new MembershipRemovalRequest();
        req.setStatus(Request.STATUS.SUBMITTED);
        req.setRequesterInfo(RequesterInfo.fromVOUser(usr));
        req.setCreationDate(new Date());
        req.setExpirationDate(expirationDate);
        req.setReason(reason);
        this.makePersistent(req);
        return req;
    }

    @Override
    public RoleMembershipRequest createRoleMembershipRequest(VOMSUser usr, VOMSGroup group, VOMSRole r, Date expirationDate) {
        if (usr.hasRole(group, r)) {
            throw new AlreadyMemberException("User '" + usr + "' already has role '" + r.getName() + "' in group '" + group + "'!");
        }
        RoleMembershipRequest req = new RoleMembershipRequest();
        req.setStatus(Request.STATUS.SUBMITTED);
        req.setRequesterInfo(RequesterInfo.fromVOUser(usr));
        req.setCreationDate(new Date());
        req.setExpirationDate(expirationDate);
        req.setGroupName(group.getName());
        req.setRoleName(r.getName());
        this.makePersistent(req);
        return req;
    }

    @Override
    public NewVOMembershipRequest createVOMembershipRequest(RequesterInfo requester, Date expirationDate) {
        NewVOMembershipRequest req = new NewVOMembershipRequest();
        req.setStatus(Request.STATUS.SUBMITTED);
        req.setRequesterInfo(requester);
        req.setCreationDate(new Date());
        req.setExpirationDate(expirationDate);
        req.setConfirmId(UUID.randomUUID().toString());
        this.makePersistent(req);
        return req;
    }

    @Override
    public void deleteRequestFromUser(VOMSUser u) {
        List<Request> userReqs = this.findRequestsFromUser(u);
        for (Request r : userReqs) {
            this.makeTransient(r);
        }
    }

    @Override
    public NewVOMembershipRequest findActiveVOMembershipRequest(RequesterInfo requester) {
        Criteria crit = this.getSession().createCriteria(NewVOMembershipRequest.class);
        crit.add((Criterion)Restrictions.ne((String)"status", (Object)((Object)Request.STATUS.APPROVED))).add((Criterion)Restrictions.ne((String)"status", (Object)((Object)Request.STATUS.REJECTED))).createCriteria("requesterInfo").add((Criterion)Restrictions.eq((String)"certificateSubject", (Object)requester.getCertificateSubject())).add((Criterion)Restrictions.eq((String)"certificateIssuer", (Object)requester.getCertificateIssuer()));
        return (NewVOMembershipRequest)crit.uniqueResult();
    }

    @Override
    public List<NewVOMembershipRequest> findConfirmedVOMembershipRequests() {
        Criteria crit = this.getSession().createCriteria(NewVOMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.CONFIRMED)));
        return crit.list();
    }

    @Override
    public List<NewVOMembershipRequest> findPendingVOMembershipRequests() {
        Criteria crit = this.getSession().createCriteria(NewVOMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED)));
        return crit.list();
    }

    @Override
    public List<NewVOMembershipRequest> findExpiredVOMembershipRequests() {
        Criteria crit = this.getSession().createCriteria(NewVOMembershipRequest.class);
        Date now = new Date();
        crit.add((Criterion)Restrictions.lt((String)"expirationDate", (Object)now));
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED)));
        return crit.list();
    }

    @Override
    public List<CertificateRequest> findPendingCertificateRequests() {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED)));
        return crit.list();
    }

    @Override
    public List<GroupMembershipRequest> findPendingGroupMembershipRequests() {
        Criteria crit = this.getSession().createCriteria(GroupMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED)));
        return crit.list();
    }

    @Override
    public List<MembershipRemovalRequest> findPendingMembershipRemovalRequests() {
        Criteria crit = this.getSession().createCriteria(MembershipRemovalRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED)));
        return crit.list();
    }

    @Override
    public List<Request> findPendingRequests() {
        ArrayList<Request> result = new ArrayList<Request>();
        result.addAll(this.findPendingVOMembershipRequests());
        result.addAll(this.findConfirmedVOMembershipRequests());
        result.addAll(this.findPendingGroupMembershipRequests());
        result.addAll(this.findPendingRoleMembershipRequests());
        result.addAll(this.findPendingCertificateRequests());
        result.addAll(this.findPendingMembershipRemovalRequests());
        return result;
    }

    @Override
    public List<RoleMembershipRequest> findPendingRoleMembershipRequests() {
        Criteria crit = this.getSession().createCriteria(RoleMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED)));
        return crit.list();
    }

    @Override
    public List<CertificateRequest> findPendingUserCertificateRequests(VOMSUser u) {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class);
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        return crit.list();
    }

    @Override
    public List<GroupMembershipRequest> findPendingUserGroupMembershipRequests(VOMSUser u) {
        Criteria crit = this.getSession().createCriteria(GroupMembershipRequest.class);
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        return crit.list();
    }

    @Override
    public List<MembershipRemovalRequest> findPendingUserMembershipRemovalRequests(VOMSUser u) {
        Criteria crit = this.getSession().createCriteria(MembershipRemovalRequest.class);
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        return crit.list();
    }

    @Override
    public List<RoleMembershipRequest> findPendingUserRoleMembershipRequests(VOMSUser u) {
        Criteria crit = this.getSession().createCriteria(RoleMembershipRequest.class);
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        return crit.list();
    }

    @Override
    public List<NewVOMembershipRequest> findRejectedVOMembershipRequests() {
        Criteria crit = this.getSession().createCriteria(NewVOMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.REJECTED)));
        return crit.list();
    }

    @Override
    public List<Request> findRequestsFromUser(VOMSUser u) {
        Criteria crit = this.getSession().createCriteria(Request.class);
        crit.addOrder(Order.desc((String)"creationDate"));
        crit.createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        return crit.list();
    }

    protected Disjunction getDnEqualityCheckConstraints(VOMSUser u) {
        Disjunction dnEqualityChecks = Restrictions.disjunction();
        for (Certificate c : u.getCertificates()) {
            dnEqualityChecks.add((Criterion)Restrictions.eq((String)"certificateSubject", (Object)c.getSubjectString()));
        }
        return dnEqualityChecks;
    }

    @Override
    public boolean userHasPendingCertificateRequest(VOMSUser u, String certificateSubject, String certificateIssuer) {
        Criteria crit = this.getSession().createCriteria(CertificateRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"certificateSubject", (Object)certificateSubject));
        crit.add((Criterion)Restrictions.eq((String)"certificateIssuer", (Object)certificateIssuer));
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        List reqs = crit.list();
        return reqs != null && !reqs.isEmpty();
    }

    @Override
    public boolean userHasPendingGroupMembershipRequest(VOMSUser u, VOMSGroup g) {
        Criteria crit = this.getSession().createCriteria(GroupMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"groupName", (Object)g.getName()));
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        List reqs = crit.list();
        return reqs != null && !reqs.isEmpty();
    }

    @Override
    public boolean userHasPendingMembershipRemovalRequest(VOMSUser u) {
        Criteria crit = this.getSession().createCriteria(MembershipRemovalRequest.class);
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        List reqs = crit.list();
        return reqs != null && !reqs.isEmpty();
    }

    @Override
    public boolean userHasPendingRoleMembershipRequest(VOMSUser u, VOMSGroup g, VOMSRole r) {
        Criteria crit = this.getSession().createCriteria(RoleMembershipRequest.class);
        crit.add((Criterion)Restrictions.eq((String)"groupName", (Object)g.getName()));
        crit.add((Criterion)Restrictions.eq((String)"roleName", (Object)r.getName()));
        crit.add((Criterion)Restrictions.disjunction().add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.SUBMITTED))).add((Criterion)Restrictions.eq((String)"status", (Object)((Object)Request.STATUS.PENDING)))).createCriteria("requesterInfo").add((Criterion)this.getDnEqualityCheckConstraints(u));
        List reqs = crit.list();
        return reqs != null && !reqs.isEmpty();
    }
}

