/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.dao.ACLDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSCADAO;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchCAException;
import org.glite.security.voms.admin.persistence.error.VOMSDatabaseException;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.Tag;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.util.DNUtil;
import org.glite.security.voms.admin.util.PathNamingScheme;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSAdminDAO {
    public static final Logger log = LoggerFactory.getLogger(VOMSAdminDAO.class);

    protected VOMSAdminDAO() {
        HibernateFactory.beginTransaction();
    }

    public static VOMSAdminDAO instance() {
        return new VOMSAdminDAO();
    }

    public List getAll() {
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin";
        List result = HibernateFactory.getSession().createQuery(query).list();
        return result;
    }

    public List<VOMSAdmin> getNonInternalAdmins() {
        String caDN = "/O=VOMS/O=System%";
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin where ca.subjectString not like :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("caDN", caDN);
        return q.list();
    }

    public VOMSAdmin getAnyAuthenticatedUserAdmin() {
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin as a where a.dn = :dn and a.ca.subjectString = :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("dn", "/O=VOMS/O=System/CN=Any Authenticated User");
        q.setString("caDN", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
        VOMSAdmin a = (VOMSAdmin)q.uniqueResult();
        if (a == null) {
            throw new VOMSDatabaseException("Database corrupted! ANYUSER_ADMIN not found in admins table!");
        }
        return a;
    }

    public VOMSAdmin createUnauthenticateClientAdmin() {
        return this.create("/O=VOMS/O=System/CN=Unauthenticated Client", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
    }

    public VOMSAdmin getUnauthenticatedClientAdmin() {
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin as a where a.dn = :dn and a.ca.subjectString = :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("dn", "/O=VOMS/O=System/CN=Unauthenticated Client");
        q.setString("caDN", "/O=VOMS/O=System/CN=Dummy Certificate Authority");
        VOMSAdmin a = (VOMSAdmin)q.uniqueResult();
        return a;
    }

    public VOMSAdmin getById(Long id) {
        if (id == null) {
            throw new NullArgumentException("id must be non-null!");
        }
        return (VOMSAdmin)HibernateFactory.getSession().load(VOMSAdmin.class, (Serializable)id);
    }

    public VOMSAdmin getBySubject(String subject) {
        if (subject == null) {
            throw new NullArgumentException("subject must be non-null!");
        }
        subject = DNUtil.normalizeDN(subject);
        Criteria crit = HibernateFactory.getSession().createCriteria(VOMSAdmin.class);
        return (VOMSAdmin)crit.add((Criterion)Restrictions.eq((String)"dn", (Object)subject)).uniqueResult();
    }

    public VOMSAdmin getByName(String dn, String caDN) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        dn = DNUtil.normalizeDN(dn);
        caDN = DNUtil.normalizeDN(caDN);
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin as a where a.dn = :dn and a.ca.subjectString = :caDN";
        Query q = HibernateFactory.getSession().createQuery(query);
        q.setString("dn", dn);
        q.setString("caDN", caDN);
        return (VOMSAdmin)q.uniqueResult();
    }

    public VOMSAdmin getFromUser(VOMSUser u) {
        Certificate c;
        assert (u != null) : "Cannot look for an admin starting from a null user!";
        VOMSAdmin result = null;
        Iterator<Certificate> i$ = u.getCertificates().iterator();
        while (i$.hasNext() && (result = this.getByName((c = i$.next()).getSubjectString(), c.getCa().getSubjectString())) == null) {
        }
        return result;
    }

    public VOMSAdmin createFromUser(VOMSUser u) {
        assert (u != null) : "Cannot create an admin starting from a null user!";
        VOMSAdmin admin = this.getFromUser(u);
        if (admin != null) {
            return admin;
        }
        admin = new VOMSAdmin();
        Certificate c = u.getDefaultCertificate();
        admin.setDn(c.getSubjectString());
        admin.setCa(c.getCa());
        admin.setEmailAddress(u.getEmailAddress());
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public List getRoleAdmins(VOMSRole r) {
        String searchString = "%Role=" + r.getName();
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin where dn like :searchString";
        return HibernateFactory.getSession().createQuery(query).setString("searchString", searchString).list();
    }

    public void deleteRoleAdmins(VOMSRole r) {
        String searchString = "%Role=" + r.getName();
        String query = "from org.glite.security.voms.admin.persistence.model.VOMSAdmin where dn like :searchString";
        Iterator i = HibernateFactory.getSession().createQuery(query).setString("searchString", searchString).iterate();
        while (i.hasNext()) {
            VOMSAdmin a = (VOMSAdmin)i.next();
            this.delete(a);
        }
    }

    public VOMSAdmin getByFQAN(String fqan) {
        if (fqan == null) {
            throw new NullArgumentException("fqan must be non-null!");
        }
        if (PathNamingScheme.isGroup(fqan)) {
            return this.getByName(fqan, "/O=VOMS/O=System/CN=VOMS Group");
        }
        if (PathNamingScheme.isQualifiedRole(fqan)) {
            return this.getByName(fqan, "/O=VOMS/O=System/CN=VOMS Role");
        }
        return null;
    }

    public VOMSAdmin create(String fqan) {
        if (fqan == null) {
            throw new NullArgumentException("fqan must be non-null!");
        }
        PathNamingScheme.checkSyntax(fqan);
        VOMSAdmin admin = new VOMSAdmin();
        admin.setDn(fqan);
        if (PathNamingScheme.isGroup(fqan)) {
            admin.setCa(VOMSCADAO.instance().getGroupCA());
        } else if (PathNamingScheme.isQualifiedRole(fqan)) {
            admin.setCa(VOMSCADAO.instance().getRoleCA());
        }
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public VOMSAdmin create(String dn, String caDN) {
        return this.create(dn, caDN, null);
    }

    public VOMSAdmin create(String dn, String caDN, String emailAddress) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        caDN = DNUtil.normalizeDN(caDN);
        VOMSAdmin admin = new VOMSAdmin();
        VOMSCA ca = VOMSCADAO.instance().getByName(caDN);
        if (ca == null) {
            throw new IllegalArgumentException("Unkown CA " + caDN + " passed as argument!");
        }
        dn = DNUtil.normalizeDN(dn);
        admin.setDn(dn);
        admin.setCa(ca);
        admin.setEmailAddress(emailAddress);
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public VOMSAdmin create(VOMSAdmin admin) {
        if (admin == null) {
            throw new NullArgumentException("admin must not be null!");
        }
        admin.setDn(DNUtil.normalizeDN(admin.getDn()));
        HibernateFactory.getSession().save((Object)admin);
        return admin;
    }

    public void delete(VOMSAdmin admin) {
        if (admin == null) {
            throw new NullArgumentException("admin must not be null!");
        }
        HibernateFactory.getSession().delete((Object)admin);
    }

    public List<VOMSAdmin> getFromCA(VOMSCA ca) {
        assert (ca != null) : "ca must be non-null!";
        String query = "from VOMSAdmin where ca = :ca";
        return HibernateFactory.getSession().createQuery(query).setEntity("ca", (Object)ca).list();
    }

    public void deleteFromCA(VOMSCA ca) {
        assert (ca != null) : "ca must be non-null!";
        log.debug("Deleting all admins from CA '" + ca + "'");
        ACLDAO aclDAO = ACLDAO.instance();
        for (VOMSAdmin a : this.getFromCA(ca)) {
            if (aclDAO.hasActivePermissions(a)) {
                aclDAO.deletePermissionsForAdmin(a);
            }
            HibernateFactory.getSession().delete((Object)a);
        }
    }

    public void delete(String dn, String caDN) {
        if (dn == null) {
            throw new NullArgumentException("dn must be non-null!");
        }
        if (caDN == null) {
            throw new NullArgumentException("caDN must be non-null!");
        }
        VOMSCA ca = VOMSCADAO.instance().getByName(caDN);
        if (ca == null) {
            throw new NoSuchCAException("Unknown CA '" + caDN + "'.");
        }
        Query q = HibernateFactory.getSession().createQuery("delete from org.glite.security.voms.admin.persistence.model.VOMSAdmin where dn = :dn and ca =:ca").setString("dn", dn).setParameter("ca", (Object)ca);
        q.executeUpdate();
    }

    public void saveOrUpdate(VOMSAdmin a) {
        HibernateFactory.getSession().saveOrUpdate((Object)a);
    }

    public void update(VOMSAdmin a) {
        HibernateFactory.getSession().update((Object)a);
    }

    public void assignTagInGroup(VOMSAdmin a, Tag t, VOMSGroup g) {
    }

    public void assignTagInAllGroups(VOMSAdmin a, Tag t) {
        List groups = VOMSGroupDAO.instance().findAll();
        for (VOMSGroup g : groups) {
            if (a.getTagsInGroup(g).contains(t)) continue;
            a.assignTagInGroup(g, t);
        }
        this.update(a);
    }
}

