/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.glite.security.voms.admin.operations.CurrentAdmin;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;

public class DAOUtils {
    public static List<VOMSGroup> filterUnvisibleGroups(List<VOMSGroup> groups) {
        TreeSet<VOMSGroup> visiblePaths = new TreeSet<VOMSGroup>();
        TreeSet<VOMSGroup> bannedPaths = new TreeSet<VOMSGroup>();
        ArrayList<VOMSGroup> filteredGroups = new ArrayList<VOMSGroup>();
        CurrentAdmin admin = CurrentAdmin.instance();
        for (VOMSGroup g : groups) {
            VOMSGroup parent = g.getParent();
            if (visiblePaths.contains(parent)) {
                filteredGroups.add(g);
                continue;
            }
            boolean descendsFromBannedPath = false;
            for (VOMSGroup bannedPath : bannedPaths) {
                if (!g.isDescendant(bannedPath)) continue;
                descendsFromBannedPath = true;
                break;
            }
            if (descendsFromBannedPath) continue;
            if (admin.hasPermissions(VOMSContext.instance(parent), VOMSPermission.getContainerReadPermission())) {
                visiblePaths.add(parent);
                filteredGroups.add(g);
                continue;
            }
            bannedPaths.add(parent);
        }
        return filteredGroups;
    }
}

