/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.persistence;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.security.auth.x500.X500Principal;
import org.hibernate.HibernateException;
import org.hibernate.usertype.UserType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X500PrincipalType
implements UserType {
    private static final Logger log = LoggerFactory.getLogger(X500PrincipalType.class);
    private static final int[] SQL_TYPES = new int[]{2004};
    private static final int BUF_SIZE = 2048;

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public int hashCode(Object x) throws HibernateException {
        return x.hashCode();
    }

    public boolean isMutable() {
        return true;
    }

    private X500Principal readPrincipal(InputStream is) {
        try {
            byte[] buf = new byte[2048];
            int readBytes = is.read(buf);
            byte[] val = new byte[readBytes];
            System.arraycopy(buf, 0, val, 0, readBytes);
            return new X500Principal(val);
        }
        catch (IOException e) {
            log.error("Error deserializing principal DER representation!");
            return null;
        }
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        InputStream is = rs.getBinaryStream(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        return this.readPrincipal(is);
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            statement.setNull(index, 2004);
        } else {
            X500Principal p = (X500Principal)value;
            ByteArrayInputStream bas = new ByteArrayInputStream(p.getEncoded());
            statement.setBinaryStream(index, (InputStream)bas, p.getEncoded().length);
        }
    }

    public Class returnedClass() {
        return X500Principal.class;
    }

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        X500Principal p = (X500Principal)value;
        X500Principal clone = new X500Principal(p.getEncoded());
        return clone;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }
}

