/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import java.util.Date;
import org.glite.security.voms.admin.core.validation.ValidationUtil;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.user.UserRestoredEvent;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreUserOperation
extends BaseVomsOperation {
    public static final Logger log = LoggerFactory.getLogger(RestoreUserOperation.class);
    VOMSUser user;

    protected RestoreUserOperation(Long userId) {
        this.user = VOMSUserDAO.instance().findById(userId);
    }

    protected RestoreUserOperation(VOMSUser u) {
        this.user = u;
    }

    public static RestoreUserOperation instance(Long id) {
        return new RestoreUserOperation(id);
    }

    public static RestoreUserOperation instance(VOMSUser u) {
        return new RestoreUserOperation(u);
    }

    @Override
    protected Object doExecute() {
        log.info("Restoring user {}.", (Object)this.user.getShortName());
        if (this.user.isSuspended()) {
            if (this.user.getSuspensionReason().equals(VOMSUser.SuspensionReason.FAILED_TO_SIGN_AUP.getMessage())) {
                AUPDAO aupDAO = DAOFactory.instance().getAUPDAO();
                VOMSUserDAO.instance().signAUP(this.user, aupDAO.getVOAUP());
                log.debug("Creating AUP acceptance record for user {}", (Object)this.user);
            }
            if (this.user.hasExpired()) {
                Date expirationDate = ValidationUtil.membershipExpirationDateStartingFromNow();
                log.debug("Extending membership for user {} to {}", (Object)this.user, (Object)expirationDate);
                this.user.setEndTime(expirationDate);
            }
            this.user.restore();
            EventManager.dispatch(new UserRestoredEvent(this.user));
        }
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission().setSuspendPermission());
    }
}

