/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.CertificateDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchCertificateException;
import org.glite.security.voms.admin.persistence.model.Certificate;

public class RestoreUserCertificateOperation
extends BaseVomsOperation {
    Certificate certificate;

    private RestoreUserCertificateOperation(Certificate c) {
        this.certificate = c;
    }

    private RestoreUserCertificateOperation(String subject, String issuerSubject) {
        this.certificate = CertificateDAO.instance().findByDNCA(subject, issuerSubject);
        if (this.certificate == null) {
            throw new NoSuchCertificateException("Certificate identified by '" + subject + "', '" + issuerSubject + "' not found!");
        }
    }

    public static RestoreUserCertificateOperation instance(String subject, String issuerSubject) {
        return new RestoreUserCertificateOperation(subject, issuerSubject);
    }

    public static RestoreUserCertificateOperation instance(Certificate c) {
        return new RestoreUserCertificateOperation(c);
    }

    @Override
    protected Object doExecute() {
        if (this.certificate == null) {
            throw new NullArgumentException("certificate cannot be null");
        }
        this.certificate.restore();
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission().setSuspendPermission());
    }
}

