/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import org.glite.security.voms.admin.apiv2.VOMSUserJSON;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;

public class CreateUserOperation
extends BaseVomsOperation {
    VOMSUser usr = null;
    String caDN = null;

    private CreateUserOperation(VOMSUser user, String caSubject) {
        this.usr = user;
        this.caDN = caSubject;
    }

    private CreateUserOperation(String username, String caName, String cn, String certUri, String email) {
        this.usr = new VOMSUser();
        this.usr.setDn(username);
        this.usr.setEmailAddress(email);
        this.caDN = caName;
    }

    private CreateUserOperation(NewVOMembershipRequest request) {
        this.usr = VOMSUser.fromRequesterInfo(request.getRequesterInfo());
        this.caDN = request.getRequesterInfo().getCertificateIssuer();
    }

    private CreateUserOperation(VOMSUserJSON user, String certSubject, String caSubject) {
        this.usr = VOMSUser.fromVOMSUserJSON(user);
        this.usr.setDn(certSubject);
        this.caDN = caSubject;
    }

    @Override
    protected Object doExecute() {
        VOMSUser user = VOMSUserDAO.instance().create(this.usr, this.caDN);
        if (!VOMSConfiguration.instance().getBoolean("voms.aup.require_signature_for_created_users", false)) {
            VOMSUserDAO.instance().signAUP(user);
        }
        return user;
    }

    public static CreateUserOperation instance(NewVOMembershipRequest request) {
        return new CreateUserOperation(request);
    }

    public static CreateUserOperation instance(VOMSUser user, String caString) {
        return new CreateUserOperation(user, caString);
    }

    public static CreateUserOperation instance(VOMSUserJSON user, String certificateSubject, String caString) {
        return new CreateUserOperation(user, certificateSubject, caString);
    }

    public static CreateUserOperation instance(String username, String caName, String cn, String certUri, String email) {
        return new CreateUserOperation(username, caName, cn, certUri, email);
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions().setMembershipRWPermission());
    }
}

