/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.users;

import java.security.cert.X509Certificate;
import java.util.Date;
import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class AddUserCertificateOperation
extends BaseVomsOperation {
    VOMSUser theUser;
    X509Certificate theCert;
    String subject;
    String issuer;
    Date notAfter;

    protected AddUserCertificateOperation(VOMSUser u, X509Certificate cert) {
        if (u == null) {
            throw new NullArgumentException("User cannot be null!");
        }
        if (cert == null) {
            throw new NullArgumentException("cert cannot be null!");
        }
        this.theUser = u;
        this.theCert = cert;
    }

    protected AddUserCertificateOperation(VOMSUser u, String certSubject, String certIssuer, String certNotAfter) {
        if (u == null) {
            throw new NullArgumentException("User cannot be null!");
        }
        if (certSubject == null) {
            throw new NullArgumentException("certSubject cannot be null!");
        }
        if (certIssuer == null) {
            throw new NullArgumentException("certIssuer cannot be null!");
        }
        this.theUser = u;
        this.subject = certSubject;
        this.issuer = certIssuer;
    }

    public static AddUserCertificateOperation instance(VOMSUser u, X509Certificate cert) {
        return new AddUserCertificateOperation(u, cert);
    }

    public static AddUserCertificateOperation instance(VOMSUser u, String certSubject, String certIssuer, String certNotAfter) {
        return new AddUserCertificateOperation(u, certSubject, certIssuer, certNotAfter);
    }

    @Override
    protected Object doExecute() {
        if (this.theCert != null) {
            VOMSUserDAO.instance().addCertificate(this.theUser, this.theCert);
        } else {
            VOMSUserDAO.instance().addCertificate(this.theUser, this.subject, this.issuer);
        }
        return null;
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions().setMembershipRWPermission());
    }
}

