/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.search;

import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.BaseVoReadOperation;
import org.glite.security.voms.admin.operations.groups.SearchGroupsOperation;
import org.glite.security.voms.admin.operations.groups.SearchMembersOperation;
import org.glite.security.voms.admin.operations.roles.SearchRolesOperation;
import org.glite.security.voms.admin.operations.search.SearchOperation;
import org.glite.security.voms.admin.operations.users.SearchUserAttributesOperation;
import org.glite.security.voms.admin.operations.users.SearchUsersOperation;
import org.glite.security.voms.admin.view.actions.SearchData;

public class BaseSearchOperation
extends BaseVoReadOperation
implements SearchOperation {
    SearchData searchData;
    int userMaxResults = VOMSConfiguration.instance().getInt("voms.pagination.user.max.results.per.page", 15);
    int groupMaxResults = VOMSConfiguration.instance().getInt("voms.pagination.group.max.results.per.page", 15);
    int roleMaxResults = VOMSConfiguration.instance().getInt("voms.pagination.role.max.results.per.page", 15);
    int attributeMaxResults = VOMSConfiguration.instance().getInt("voms.pagination.attributes.max.results.per.page", 15);

    protected BaseSearchOperation(SearchData sd) {
        this.setSearchData(sd);
    }

    @Override
    protected Object doExecute() {
        if (this.searchData == null) {
            return SearchUsersOperation.instance(null, 0, this.userMaxResults).execute();
        }
        String searchType = this.searchData.getType().toLowerCase();
        if (this.searchData.getText() != null && this.searchData.getText().trim().equals("")) {
            this.searchData.setText(null);
        }
        if (this.searchData.getMaxResults() == 0) {
            this.searchData.setMaxResults(this.userMaxResults);
        }
        if (searchType.equals("user")) {
            return SearchUsersOperation.instance(this.searchData.getText(), this.searchData.getFirstResult(), this.searchData.getMaxResults()).execute();
        }
        if (searchType.equals("group")) {
            return SearchGroupsOperation.instance(this.searchData.getText(), this.searchData.getFirstResult(), this.groupMaxResults).execute();
        }
        if (searchType.equals("role")) {
            return SearchRolesOperation.instance(this.searchData.getText(), this.searchData.getFirstResult(), this.groupMaxResults).execute();
        }
        if (searchType.equals("attribute")) {
            return SearchUserAttributesOperation.instance(this.searchData.getText(), this.searchData.getFirstResult(), this.groupMaxResults).execute();
        }
        if (searchType.equals("group-member") || searchType.equals("role-member")) {
            return SearchMembersOperation.instance(this.searchData).execute();
        }
        throw new VOMSException("Unsupported search type '" + this.searchData.getType() + "'");
    }

    @Override
    public SearchData getSearchData() {
        return this.searchData;
    }

    @Override
    public void setSearchData(SearchData data) {
        this.searchData = data;
    }

    public static SearchOperation instance(SearchData sd) {
        return new BaseSearchOperation(sd);
    }
}

