/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import java.util.List;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.VOMembershipRequestApprovedEvent;
import org.glite.security.voms.admin.event.registration.VOMembershipRequestRejectedEvent;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.requests.BaseHandleRequestOperation;
import org.glite.security.voms.admin.operations.requests.DECISION;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.model.AUPVersion;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.NewVOMembershipRequest;
import org.glite.security.voms.admin.persistence.model.request.Request;

public class HandleVOMembershipRequest
extends BaseHandleRequestOperation<NewVOMembershipRequest> {
    private static final String REJECT_MOTIVATION = "The VO administrator didn't find appropriate to approve your membership request.";
    List<String> approvedGroups;

    public HandleVOMembershipRequest(NewVOMembershipRequest request, DECISION decision, List<String> approvedGroups) {
        super(request, decision);
        this.approvedGroups = approvedGroups;
    }

    @Override
    protected void approve() {
        this.checkRequestStatus(Request.STATUS.CONFIRMED);
        VOMSUser user = VOMSUser.fromRequesterInfo(((NewVOMembershipRequest)this.request).getRequesterInfo());
        VOMSUserDAO.instance().create(user, ((NewVOMembershipRequest)this.request).getRequesterInfo().getCertificateIssuer());
        ((NewVOMembershipRequest)this.request).approve();
        AUPDAO aupDAO = DAOFactory.instance().getAUPDAO();
        AUPVersion currentAUPVersion = aupDAO.getVOAUP().getActiveVersion();
        String signedAUPVersion = ((NewVOMembershipRequest)this.request).getRequesterInfo().getInfo("signedAUPVersion");
        if (signedAUPVersion == null || currentAUPVersion.getVersion().equals(signedAUPVersion)) {
            VOMSUserDAO.instance().signAUP(user, aupDAO.getVOAUP());
        }
        if (this.approvedGroups != null) {
            VOMSGroupDAO groupDAO = VOMSGroupDAO.instance();
            for (String groupName : this.approvedGroups) {
                VOMSGroup g = groupDAO.findByName(groupName);
                if (g == null) continue;
                user.addToGroup(g);
            }
        }
        EventManager.dispatch(new VOMembershipRequestApprovedEvent((NewVOMembershipRequest)this.request));
    }

    @Override
    protected void reject() {
        ((NewVOMembershipRequest)this.request).reject();
        EventManager.dispatch(new VOMembershipRequestRejectedEvent((NewVOMembershipRequest)this.request, REJECT_MOTIVATION));
        DAOFactory.instance().getRequestDAO().makeTransient(this.request);
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission().setRequestsReadPermission().setRequestsWritePermission());
    }
}

