/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.MembershipRemovalApprovedEvent;
import org.glite.security.voms.admin.event.registration.MembershipRemovalRejectedEvent;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.requests.BaseHandleRequestOperation;
import org.glite.security.voms.admin.operations.requests.DECISION;
import org.glite.security.voms.admin.operations.users.DeleteUserOperation;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.MembershipRemovalRequest;
import org.glite.security.voms.admin.persistence.model.request.Request;

public class HandleMembershipRemovalRequest
extends BaseHandleRequestOperation<MembershipRemovalRequest> {
    public HandleMembershipRemovalRequest(MembershipRemovalRequest request, DECISION decision) {
        super(request, decision);
    }

    @Override
    protected void approve() {
        this.checkRequestStatus(Request.STATUS.SUBMITTED);
        VOMSUser u = this.getRequesterAsVomsUser();
        DeleteUserOperation.instance(u).execute();
        ((MembershipRemovalRequest)this.request).approve();
        EventManager.dispatch(new MembershipRemovalApprovedEvent((MembershipRemovalRequest)this.request));
    }

    @Override
    protected void reject() {
        this.checkRequestStatus(Request.STATUS.SUBMITTED);
        ((MembershipRemovalRequest)this.request).reject();
        EventManager.dispatch(new MembershipRemovalRejectedEvent((MembershipRemovalRequest)this.request));
    }

    @Override
    protected void setupPermissions() {
        this.addRequiredPermission(VOMSContext.getVoContext(), VOMSPermission.getContainerRWPermissions().setMembershipRWPermission());
    }
}

