/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.registration.GroupMembershipApprovedEvent;
import org.glite.security.voms.admin.event.registration.GroupMembershipRejectedEvent;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.groups.AddMemberOperation;
import org.glite.security.voms.admin.operations.requests.BaseHandleRequestOperation;
import org.glite.security.voms.admin.operations.requests.DECISION;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.GroupMembershipRequest;
import org.glite.security.voms.admin.persistence.model.request.Request;

public class HandleGroupRequestOperation
extends BaseHandleRequestOperation<GroupMembershipRequest> {
    public HandleGroupRequestOperation(GroupMembershipRequest request, DECISION decision) {
        super(request, decision);
    }

    @Override
    protected void approve() {
        this.checkRequestStatus(Request.STATUS.SUBMITTED);
        VOMSUser u = this.getRequesterAsVomsUser();
        VOMSGroup g = this.findGroupByName(((GroupMembershipRequest)this.request).getGroupName());
        if (!u.isMember(g)) {
            AddMemberOperation.instance(u, g).execute();
        }
        ((GroupMembershipRequest)this.request).approve();
        EventManager.dispatch(new GroupMembershipApprovedEvent((GroupMembershipRequest)this.request));
    }

    @Override
    protected void reject() {
        this.checkRequestStatus(Request.STATUS.SUBMITTED);
        ((GroupMembershipRequest)this.request).reject();
        EventManager.dispatch(new GroupMembershipRejectedEvent((GroupMembershipRequest)this.request));
    }

    @Override
    protected void setupPermissions() {
        VOMSGroup g = this.findGroupByName(((GroupMembershipRequest)this.request).getGroupName());
        this.addRequiredPermissionOnPath(g, VOMSPermission.getContainerReadPermission());
        this.addRequiredPermission(VOMSContext.instance(g), VOMSPermission.getMembershipRWPermissions());
        this.addRequiredPermission(VOMSContext.instance(g), VOMSPermission.getRequestsRWPermissions());
    }
}

