/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.requests;

import org.glite.security.voms.admin.error.IllegalRequestStateException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.requests.DECISION;
import org.glite.security.voms.admin.operations.users.FindUserOperation;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.error.NoSuchGroupException;
import org.glite.security.voms.admin.persistence.error.NoSuchRoleException;
import org.glite.security.voms.admin.persistence.error.NoSuchUserException;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.request.Request;

public abstract class BaseHandleRequestOperation<T extends Request>
extends BaseVomsOperation {
    protected DECISION decision = DECISION.REJECT;
    T request;

    public BaseHandleRequestOperation(T request, DECISION decision) {
        this.request = request;
        this.decision = decision;
    }

    protected abstract void approve();

    protected void checkRequestStatus(Request.STATUS status) {
        if (!((Request)this.request).getStatus().equals((Object)status)) {
            throw new IllegalRequestStateException("Illegal state for request: " + (Object)((Object)((Request)this.request).getStatus()));
        }
    }

    @Override
    protected final Object doExecute() {
        if (this.decision.equals((Object)DECISION.APPROVE)) {
            this.approve();
        } else {
            this.reject();
        }
        return this.request;
    }

    protected final VOMSGroup findGroupByName(String groupName) {
        VOMSGroup g = VOMSGroupDAO.instance().findByName(groupName);
        if (g == null) {
            throw new NoSuchGroupException("Requested group '" + groupName + "' does not exist in this VO.");
        }
        return g;
    }

    protected final VOMSRole findRoleByName(String roleName) {
        VOMSRole r = VOMSRoleDAO.instance().findByName(roleName);
        if (r == null) {
            throw new NoSuchRoleException("Requested role '" + roleName + "' does not exist in this VO.");
        }
        return r;
    }

    public DECISION getDecision() {
        return this.decision;
    }

    public T getRequest() {
        return this.request;
    }

    protected final VOMSUser getRequesterAsVomsUser() {
        VOMSUser u = (VOMSUser)FindUserOperation.instance(((Request)this.request).getRequesterInfo().getCertificateSubject(), ((Request)this.request).getRequesterInfo().getCertificateIssuer()).execute();
        if (u == null) {
            throw new NoSuchUserException(String.format("User '%s, %s' not found!", ((Request)this.request).getRequesterInfo().getCertificateSubject(), ((Request)this.request).getRequesterInfo().getCertificateIssuer()));
        }
        return u;
    }

    protected abstract void reject();

    protected void setDecision(DECISION decision) {
        this.decision = decision;
    }
}

