/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.groups;

import org.glite.security.voms.admin.error.NullArgumentException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSRoleDAO;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.glite.security.voms.admin.persistence.model.VOMSRole;
import org.glite.security.voms.admin.util.PathNamingScheme;

public class FindContextOperation
extends BaseVomsOperation {
    VOMSContext theContext = null;
    String contextString = null;

    private FindContextOperation(String contextString) {
        if (contextString == null) {
            throw new NullArgumentException("contextString cannot be null!");
        }
        PathNamingScheme.checkSyntax(contextString);
        this.contextString = contextString;
    }

    public static FindContextOperation instance(String contextString) {
        return new FindContextOperation(contextString);
    }

    @Override
    protected Object doExecute() {
        String groupName = PathNamingScheme.getGroupName(this.contextString);
        VOMSGroup g = VOMSGroupDAO.instance().findByName(groupName);
        if (PathNamingScheme.isQualifiedRole(this.contextString)) {
            String roleName = PathNamingScheme.getRoleName(this.contextString);
            VOMSRole r = VOMSRoleDAO.instance().findByName(roleName);
            return VOMSContext.instance(g, r);
        }
        return VOMSContext.instance(g);
    }

    @Override
    protected void setupPermissions() {
        VOMSGroup g = VOMSGroupDAO.instance().findByName(PathNamingScheme.getGroupName(this.contextString));
        this.addRequiredPermissionOnPath(g, VOMSPermission.getContainerReadPermission());
    }
}

