/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations.acls;

import java.util.Iterator;
import java.util.List;
import org.glite.security.voms.admin.error.VOMSAuthorizationException;
import org.glite.security.voms.admin.operations.BaseVomsOperation;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.persistence.dao.ACLDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSGroupDAO;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteACLEntryOperation
extends BaseVomsOperation {
    private static final Logger log = LoggerFactory.getLogger(DeleteACLEntryOperation.class);
    private ACL acl;
    private VOMSAdmin admin;
    private boolean recursive = false;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Object doExecute() {
        if (!this.isRecursive()) {
            log.debug("Removing ACL entry for admin '" + this.admin + "' in ACL '" + this.acl.getContext() + "'.");
            ACLDAO.instance().deleteACLEntry(this.acl, this.admin);
            return this.acl;
        }
        if (!this.acl.getContext().isGroupContext()) {
            log.debug("Removing ACL entry for admin '" + this.admin + "' in ACL '" + this.acl.getContext() + "' [recursive].");
            ACLDAO.instance().deleteACLEntry(this.acl, this.admin);
            return this.acl;
        }
        try {
            List childrenGroups = VOMSGroupDAO.instance().getChildren(this.acl.getGroup());
            Iterator childIter = childrenGroups.iterator();
            while (true) {
                if (!childIter.hasNext()) {
                    log.debug("Removing ACL entry for admin '" + this.admin + "' in ACL '" + this.acl.getContext() + "' [recursive].");
                    ACLDAO.instance().deleteACLEntry(this.acl, this.admin);
                    return this.acl;
                }
                VOMSGroup childGroup = (VOMSGroup)childIter.next();
                DeleteACLEntryOperation op = DeleteACLEntryOperation.instance(childGroup.getACL(), this.admin, this.recursive);
                op.execute();
            }
        }
        catch (VOMSAuthorizationException e) {
            log.warn("Authorization Error saving recursively ACL entry !");
            return null;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    @Override
    protected void setupPermissions() {
        VOMSPermission requiredPerms = null;
        requiredPerms = this.acl.isDefautlACL() ? VOMSPermission.getEmptyPermissions().setACLDefaultPermission().setACLReadPermission().setACLWritePermission() : VOMSPermission.getEmptyPermissions().setACLReadPermission().setACLWritePermission();
        this.addRequiredPermission(this.acl.getContext(), requiredPerms);
    }

    private DeleteACLEntryOperation(ACL acl, VOMSAdmin admin) {
        this.acl = acl;
        this.admin = admin;
    }

    private DeleteACLEntryOperation(ACL acl, VOMSAdmin admin, boolean propagate) {
        this.acl = acl;
        this.admin = admin;
        this.recursive = propagate;
    }

    public static DeleteACLEntryOperation instance(ACL acl, VOMSAdmin admin) {
        return new DeleteACLEntryOperation(acl, admin);
    }

    public static DeleteACLEntryOperation instance(ACL acl, VOMSAdmin admin, boolean propagate) {
        return new DeleteACLEntryOperation(acl, admin, propagate);
    }

    protected boolean isRecursive() {
        return this.recursive;
    }
}

