/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.operations;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.glite.security.voms.admin.operations.VOMSContext;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.operations.VOMSPermissionList;
import org.glite.security.voms.admin.persistence.dao.VOMSAdminDAO;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.model.ACL;
import org.glite.security.voms.admin.persistence.model.Tag;
import org.glite.security.voms.admin.persistence.model.VOMSAdmin;
import org.glite.security.voms.admin.persistence.model.VOMSCA;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.util.DNUtil;
import org.italiangrid.utils.voms.SecurityContextImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CurrentAdmin {
    private static final Logger log = LoggerFactory.getLogger(CurrentAdmin.class);
    private VOMSAdmin admin;

    public VOMSAdmin getAdmin() {
        return this.admin;
    }

    protected CurrentAdmin(VOMSAdmin a) {
        this.admin = a;
    }

    public static CurrentAdmin instance() {
        SecurityContextImpl theContext = SecurityContextImpl.getCurrentContext();
        String adminDN = theContext.getClientName();
        String caDN = theContext.getIssuerName();
        VOMSAdmin admin = VOMSAdminDAO.instance().getByName(adminDN, caDN);
        if (admin == null) {
            admin = VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin();
        }
        return new CurrentAdmin(admin);
    }

    public VOMSCA getCa() {
        return this.admin.getCa();
    }

    public String getDn() {
        return this.admin.getDn();
    }

    public boolean isAuthorizedAdmin() {
        return !this.getAdmin().equals(VOMSAdminDAO.instance().getAnyAuthenticatedUserAdmin());
    }

    public boolean isVoUser() {
        return this.getVoUser() != null;
    }

    public boolean is(VOMSUser u) {
        if (this.getVoUser() == null) {
            return false;
        }
        return this.getVoUser().equals(u);
    }

    public VOMSUser getVoUser() {
        if (!this.isAuthorizedAdmin()) {
            return VOMSUserDAO.instance().getByDNandCA(this.getRealSubject(), this.getRealIssuer());
        }
        return VOMSUserDAO.instance().getByDNandCA(this.admin.getDn(), this.admin.getCa());
    }

    public void createVoUser() {
        VOMSUser usr = this.getVoUser();
        if (usr == null) {
            VOMSUserDAO.instance().create(this.getRealSubject(), this.getRealIssuer(), this.getRealCN(), null, this.getRealEmailAddress());
        }
    }

    public boolean isVOAdmin() {
        if (this.hasPermissions(VOMSContext.getVoContext(), VOMSPermission.getAllPermissions())) {
            return true;
        }
        return this.hasPermissions(VOMSContext.getVoContext(), VOMSPermission.getRequestsRWPermissions());
    }

    public boolean canBrowseVO() {
        return this.hasPermissions(VOMSContext.getVoContext(), VOMSPermission.getContainerReadPermission().setMembershipReadPermission());
    }

    public boolean hasPermissions(VOMSContext c, VOMSPermission p) {
        ACL acl = c.getACL();
        log.debug("Checking if admin " + this.getAdmin() + " has permission " + p + " in context " + c);
        log.debug("ACL for this context: ");
        log.debug(acl.toString());
        if (this.isUnauthenticated()) {
            VOMSPermission unauthPerms = acl.getUnauthenticatedClientPermissions();
            if (unauthPerms == null) {
                return false;
            }
            return unauthPerms.satisfies(p);
        }
        VOMSUser adminUser = this.getVoUser();
        log.debug("Admin user: " + adminUser);
        VOMSPermission personalPermissions = acl.getPermissions(this.admin);
        log.debug("Personal permissions for admin: " + personalPermissions);
        VOMSPermission anyAuthenticatedUserPermissions = acl.getAnyAuthenticatedUserPermissions();
        log.debug("Permissions for any authenticated user: " + anyAuthenticatedUserPermissions);
        VOMSPermissionList adminPerms = VOMSPermissionList.instance();
        VOMSPermission unauthenticatedClientPermissions = acl.getUnauthenticatedClientPermissions();
        log.debug("Permissions for unauthenticated clients: " + unauthenticatedClientPermissions);
        if (personalPermissions == null && adminUser == null && anyAuthenticatedUserPermissions == null && unauthenticatedClientPermissions == null) {
            return false;
        }
        if (personalPermissions != null) {
            adminPerms.addPermission(personalPermissions);
        }
        if (anyAuthenticatedUserPermissions != null) {
            adminPerms.addPermission(anyAuthenticatedUserPermissions);
        }
        if (unauthenticatedClientPermissions != null) {
            adminPerms.addPermission(unauthenticatedClientPermissions);
        }
        if (adminUser == null) {
            return adminPerms.satifies(p);
        }
        Map<VOMSAdmin, VOMSPermission> groupPermissions = acl.getGroupPermissions();
        Map<VOMSAdmin, VOMSPermission> rolePermissions = acl.getRolePermissions();
        log.debug("Group permissions empty? " + groupPermissions.isEmpty());
        log.debug("Role permissions empty? " + rolePermissions.isEmpty());
        if (!groupPermissions.isEmpty()) {
            for (Map.Entry<VOMSAdmin, VOMSPermission> entry : groupPermissions.entrySet()) {
                String groupName = entry.getKey().getDn();
                if (!adminUser.isMember(groupName)) continue;
                adminPerms.addPermission(entry.getValue());
                log.debug("Adding group permission " + entry.getValue() + " to admin's permission set. admin is a member of the group '" + groupName + "'.");
            }
        }
        if (!rolePermissions.isEmpty()) {
            for (Map.Entry entry : rolePermissions.entrySet()) {
                String roleName = ((VOMSAdmin)entry.getKey()).getDn();
                log.debug("Checking if current admin has role: " + roleName);
                if (!adminUser.hasRole(roleName)) continue;
                adminPerms.addPermission((VOMSPermission)entry.getValue());
                log.debug("Adding role permission " + entry.getValue() + " to admin's permission set. admin has role '" + roleName + "'.");
            }
        }
        for (Tag tag : this.admin.getTagsInContext(c)) {
            log.debug("Adding permissions '" + tag.getPermissions() + "' from tag '" + tag.getName() + "' to admin's permission set.");
            adminPerms.addPermission(tag.getPermissions());
        }
        log.debug("Admin permissions: " + adminPerms);
        return adminPerms.satifies(p);
    }

    public String getRealSubject() {
        SecurityContextImpl theContext = SecurityContextImpl.getCurrentContext();
        return theContext.getClientName();
    }

    public String getRealIssuer() {
        SecurityContextImpl theContext = SecurityContextImpl.getCurrentContext();
        return theContext.getIssuerName();
    }

    public String getRealCN() {
        SecurityContextImpl theContext = SecurityContextImpl.getCurrentContext();
        if (theContext.getClientCert() == null) {
            return null;
        }
        String name = DNUtil.getOpenSSLSubject(theContext.getClientCert().getSubjectX500Principal());
        Matcher m = Pattern.compile("/CN=([^/]*)").matcher(name);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    public String getRealEmailAddress() {
        SecurityContextImpl theContext = SecurityContextImpl.getCurrentContext();
        if (theContext.getClientCert() == null) {
            return null;
        }
        String name = DNUtil.getOpenSSLSubject(theContext.getClientCert().getSubjectX500Principal());
        String candidateEmail = DNUtil.getEmailAddressFromDN(DNUtil.normalizeEmailAddressInDN(name));
        if (candidateEmail == null) {
            candidateEmail = DNUtil.getEmailAddressFromExtensions(theContext.getClientCert());
        }
        return candidateEmail;
    }

    public String toString() {
        return this.admin.toString();
    }

    public boolean isUnauthenticated() {
        return this.admin.isUnauthenticated();
    }
}

