/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification.messages;

import java.util.Date;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.notification.messages.AbstractVelocityNotification;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.task.SignAUPTask;
import org.glite.security.voms.admin.util.URLBuilder;

public class SignAUPMessage
extends AbstractVelocityNotification {
    VOMSUser user;
    AUP aup;

    public SignAUPMessage(VOMSUser user, AUP aup) {
        this.setUser(user);
        this.setAup(aup);
    }

    @Override
    protected void buildMessage() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        String voName = conf.getVOName();
        this.setSubject("Sign '" + this.aup.getName() + "' notification for VO '" + conf.getVOName() + "'.");
        Date expirationDate = null;
        SignAUPTask t = this.user.getPendingSignAUPTask(this.aup);
        if (t != null) {
            expirationDate = t.getExpiryDate();
        }
        this.context.put("voName", (Object)voName);
        this.context.put("aup", (Object)this.aup);
        this.context.put("user", (Object)this.user);
        this.context.put("recipient", this.getRecipientList().get(0));
        this.context.put("signAUPURL", (Object)(URLBuilder.baseVOMSURL() + "/aup/sign!input.action?aupId=" + this.aup.getId()));
        this.context.put("expirationDate", (Object)expirationDate);
        super.buildMessage();
    }

    public VOMSUser getUser() {
        return this.user;
    }

    public void setUser(VOMSUser user) {
        this.user = user;
    }

    public AUP getAup() {
        return this.aup;
    }

    public void setAup(AUP aup) {
        this.aup = aup;
    }
}

