/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification.messages;

import java.util.List;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.notification.NotificationUtil;
import org.glite.security.voms.admin.notification.messages.AbstractVelocityNotification;
import org.glite.security.voms.admin.persistence.model.request.Request;

public class HandleRequest
extends AbstractVelocityNotification {
    Request request;
    String requestManagementURL;

    public HandleRequest(Request request, String requestManagementURL, List<String> administratorEmailAddresses) {
        this.request = request;
        this.requestManagementURL = requestManagementURL;
        this.addRecipients(administratorEmailAddresses);
    }

    public HandleRequest(Request request, String requestManagementURL) {
        this(request, requestManagementURL, NotificationUtil.getAdministratorsEmailList());
    }

    @Override
    protected void buildMessage() {
        String voName = VOMSConfiguration.instance().getVOName();
        this.setSubject("A " + this.request.getTypeName().toLowerCase() + " for VO " + voName + " requires your approval.");
        this.context.put("voName", (Object)voName);
        this.context.put("recipient", (Object)"VO Admin");
        this.context.put("request", (Object)this.request);
        this.context.put("requestManagementURL", (Object)this.requestManagementURL);
        super.buildMessage();
    }
}

