/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.notification;

import java.util.Calendar;
import java.util.Date;
import org.glite.security.voms.admin.notification.ConditionalSendNotificationStrategy;
import org.glite.security.voms.admin.notification.NotificationService;
import org.glite.security.voms.admin.notification.messages.EmailNotification;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeIntervalNotificationStrategy
implements ConditionalSendNotificationStrategy {
    private static final Logger log = LoggerFactory.getLogger(TimeIntervalNotificationStrategy.class);
    private static final int DEFAULT_NOTIFICATION_PERIOD_IN_DAYS = 1;
    protected Date lastNotificationSentTime;
    protected EmailNotification lastNotificationSent;
    protected int notificationPeriod = 1;

    public TimeIntervalNotificationStrategy(int notificationPeriodInDays) {
        this.notificationPeriod = notificationPeriodInDays;
    }

    public TimeIntervalNotificationStrategy() {
    }

    @Override
    public synchronized boolean notificationRequired() {
        if (this.lastNotificationSentTime == null) {
            log.debug("Notification required since no notification was ever sent.");
            return true;
        }
        Date now = new Date();
        Date nextNotificationTime = this.getNextNotificationMessageTime();
        if (nextNotificationTime.before(now)) {
            log.debug("Notification required since next scheduled notification time {} is in the past.", (Object)nextNotificationTime);
            return true;
        }
        log.debug("No notification required. Next notification scheduled for {}.", (Object)nextNotificationTime);
        return false;
    }

    private Date getNextNotificationMessageTime() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.lastNotificationSentTime);
        cal.add(6, this.notificationPeriod);
        return cal.getTime();
    }

    @Override
    public synchronized void sendNotification(EmailNotification n) {
        if (this.notificationRequired()) {
            NotificationService.instance().send(n);
            this.lastNotificationSentTime = new Date();
            this.lastNotificationSent = n;
        }
    }
}

