/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb.model;

import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.glite.security.voms.admin.integration.orgdb.model.Country;
import org.glite.security.voms.admin.integration.orgdb.model.Institute;
import org.glite.security.voms.admin.integration.orgdb.model.Participation;
import org.hibernate.annotations.Immutable;

@Entity
@Immutable
@Table(name="VOMS_PERSONS")
public class VOMSOrgDBPerson
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Id
    @Column(name="PERSON_ID")
    Long id;
    @Column(name="IDENT", length=7)
    Long cernId;
    @Column(name="NAME", length=24, nullable=false)
    String name;
    @Column(name="FIRST_NAME", length=18, nullable=false)
    String firstName;
    @Column(name="DEPART", length=3)
    String department;
    @Column(name="GRP", length=3)
    String group;
    @Column(name="SECT", length=3)
    String sector;
    @Column(name="BUILDING", length=10)
    String building;
    @Column(name="FLOOR", length=2)
    String floor;
    @Column(name="ROOM", length=4)
    String room;
    @Column(name="TEL_1", length=5)
    String tel1;
    @Column(name="TEL_2", length=5)
    String tel2;
    @Column(name="TEL_3", length=5)
    String tel3;
    @Column(name="PORTABLE_PHONE", length=5)
    String portablePhone;
    @Column(name="BEEP", length=5)
    String beeper;
    @Column(name="EMAIL", length=60)
    String email;
    @Column(name="PHYSICAL_EMAIL", length=60)
    String physicalEmail;
    @Column(name="FIRM", length=14)
    String firm;
    @Column(name="AT_CERN", nullable=false, length=1)
    String atCern;
    @Column(name="PERSON_CLASS", length=6)
    String personClass;
    @Column(name="SUPERVISOR_OF_EXTERNAL_STAFF")
    Boolean supervisorOfExternalStuff;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="NATIONALITY1")
    Country nationality1;
    @ManyToOne(optional=true, fetch=FetchType.LAZY)
    @JoinColumn(name="INSTITUTE")
    Institute institute;
    @Temporal(value=TemporalType.DATE)
    @Column(name="DATE_OF_BIRTH")
    Date dateOfBirth;
    @Column(name="PROCESSING_START_DATE")
    Date processingStartDate;
    @Column(name="PROCESSING_END_DATE")
    Date processingEndDate;
    @OneToMany(mappedBy="vomsPerson", fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="PERSON_ID")
    Set<Participation> participations = new HashSet<Participation>();

    public Long getCernId() {
        return this.cernId;
    }

    public void setCernId(Long cernId) {
        this.cernId = cernId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getDepartment() {
        return this.department;
    }

    public void setDepartment(String department) {
        this.department = department;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getSector() {
        return this.sector;
    }

    public void setSector(String sector) {
        this.sector = sector;
    }

    public String getBuilding() {
        return this.building;
    }

    public void setBuilding(String building) {
        this.building = building;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String floor) {
        this.floor = floor;
    }

    public String getRoom() {
        return this.room;
    }

    public void setRoom(String room) {
        this.room = room;
    }

    public String getTel1() {
        return this.tel1;
    }

    public void setTel1(String tel1) {
        this.tel1 = tel1;
    }

    public String getTel2() {
        return this.tel2;
    }

    public void setTel2(String tel2) {
        this.tel2 = tel2;
    }

    public String getTel3() {
        return this.tel3;
    }

    public void setTel3(String tel3) {
        this.tel3 = tel3;
    }

    public String getPortablePhone() {
        return this.portablePhone;
    }

    public void setPortablePhone(String portablePhone) {
        this.portablePhone = portablePhone;
    }

    public String getBeeper() {
        return this.beeper;
    }

    public void setBeeper(String beeper) {
        this.beeper = beeper;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhysicalEmail() {
        return this.physicalEmail;
    }

    public void setPhysicalEmail(String physicalEmail) {
        this.physicalEmail = physicalEmail;
    }

    public String getFirm() {
        return this.firm;
    }

    public void setFirm(String firm) {
        this.firm = firm;
    }

    public String getAtCern() {
        return this.atCern;
    }

    public void setAtCern(String atCern) {
        this.atCern = atCern;
    }

    public String getPersonClass() {
        return this.personClass;
    }

    public void setPersonClass(String personClass) {
        this.personClass = personClass;
    }

    public Boolean getSupervisorOfExternalStuff() {
        return this.supervisorOfExternalStuff;
    }

    public void setSupervisorOfExternalStuff(Boolean supervisorOfExternalStuff) {
        this.supervisorOfExternalStuff = supervisorOfExternalStuff;
    }

    public Country getNationality1() {
        return this.nationality1;
    }

    public void setNationality1(Country nationality1) {
        this.nationality1 = nationality1;
    }

    public Institute getInstitute() {
        return this.institute;
    }

    public void setInstitute(Institute institute) {
        this.institute = institute;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Date getProcessingStartDate() {
        return this.processingStartDate;
    }

    public void setProcessingStartDate(Date processingStartDate) {
        this.processingStartDate = processingStartDate;
    }

    public Date getProcessingEndDate() {
        return this.processingEndDate;
    }

    public void setProcessingEndDate(Date processingEndDate) {
        this.processingEndDate = processingEndDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Set<Participation> getParticipations() {
        return this.participations;
    }

    public void setParticipations(Set<Participation> participations) {
        this.participations = participations;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VOMSOrgDBPerson other = (VOMSOrgDBPerson)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VOMSPerson [id=").append(this.id).append(", firstName=").append(this.firstName).append(", name=").append(this.name).append(", email=").append(this.email).append(", physicalEmail=").append(this.physicalEmail).append("]");
        return builder.toString();
    }

    public Participation getLastExpiredParticipationForExperiment(String experimentName) {
        Participation lastExpiredParticipation = null;
        Date now = new Date();
        for (Participation p : this.participations) {
            if (!p.getExperiment().getName().equals(experimentName) || p.getEndDate() == null || !p.getEndDate().before(now) || lastExpiredParticipation != null && (lastExpiredParticipation == null || !p.getEndDate().after(lastExpiredParticipation.getEndDate()))) continue;
            lastExpiredParticipation = p;
        }
        return lastExpiredParticipation;
    }

    public Set<Participation> getValidParticipations() {
        Date now = new Date();
        HashSet<Participation> result = new HashSet<Participation>();
        for (Participation p : this.participations) {
            if (!p.getStartDate().before(now)) continue;
            if (p.getEndDate() == null) {
                result.add(p);
                continue;
            }
            if (!p.getEndDate().after(now)) continue;
            result.add(p);
        }
        return result;
    }

    public boolean hasValidParticipationForExperiment(String experimentName) {
        return this.getValidParticipationForExperiment(experimentName) != null;
    }

    public Participation getValidParticipationForExperiment(String experimentName) {
        Date now = new Date();
        for (Participation p : this.participations) {
            if (!p.getExperiment().getName().equals(experimentName) || !p.getStartDate().before(now)) continue;
            if (p.getEndDate() == null) {
                return p;
            }
            if (!p.getEndDate().after(now)) continue;
            return p;
        }
        return null;
    }
}

