/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb.database;

import java.util.Properties;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBError;
import org.glite.security.voms.admin.integration.orgdb.model.Country;
import org.glite.security.voms.admin.integration.orgdb.model.Experiment;
import org.glite.security.voms.admin.integration.orgdb.model.Institute;
import org.glite.security.voms.admin.integration.orgdb.model.InstituteAddress;
import org.glite.security.voms.admin.integration.orgdb.model.Participation;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.context.ThreadLocalSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgDBSessionFactory {
    static final Logger log = LoggerFactory.getLogger(OrgDBSessionFactory.class);
    private static volatile SessionFactory orgDbSessionFactory;

    public static AnnotationConfiguration buildConfiguration(Properties orgDbHibernateProperties) {
        AnnotationConfiguration cfg = new AnnotationConfiguration().addAnnotatedClass(Country.class).addAnnotatedClass(Experiment.class).addAnnotatedClass(Institute.class).addAnnotatedClass(InstituteAddress.class).addAnnotatedClass(Participation.class).addAnnotatedClass(VOMSOrgDBPerson.class).setProperties(orgDbHibernateProperties);
        Properties p = new Properties();
        p.setProperty("hibernate.current_session_context_class", ThreadLocalSessionContext.class.getName());
        log.debug("Hardwired configuration properties: {}", (Object)p);
        cfg.addProperties(p);
        return cfg;
    }

    public static synchronized void initialize(Properties orgbHibernateProperties) {
        if (orgDbSessionFactory != null) {
            throw new OrgDBError("Session factory already initialized!");
        }
        try {
            AnnotationConfiguration cfg = OrgDBSessionFactory.buildConfiguration(orgbHibernateProperties);
            orgDbSessionFactory = cfg.configure().buildSessionFactory();
        }
        catch (HibernateException e) {
            String errorMsg = String.format("Cannot initialize OrgDB database connection: %s", e.getMessage());
            log.error(errorMsg, (Throwable)e);
            throw new OrgDBError(errorMsg, e);
        }
    }

    public static SessionFactory getSessionFactory() {
        if (orgDbSessionFactory == null) {
            throw new OrgDBError("Session factory not initialized!");
        }
        return orgDbSessionFactory;
    }

    public static void shutdown() {
        if (OrgDBSessionFactory.getSessionFactory() != null) {
            OrgDBSessionFactory.getSessionFactory().close();
        }
    }

    private OrgDBSessionFactory() {
    }
}

