/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb.dao;

import java.io.Serializable;
import java.util.List;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBGenericHibernateDAO;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBVOMSPersonDAO;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.hibernate.Query;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

public class OrgDBVOMSPersonDAOHibernate
extends OrgDBGenericHibernateDAO<VOMSOrgDBPerson, Long>
implements OrgDBVOMSPersonDAO {
    @Override
    public VOMSOrgDBPerson findPersonWithValidExperimentParticipationById(Long personId, String experimentName) {
        String query = "select p from VOMSOrgDBPerson p join p.participations pp where p.id = :personId and (pp.experiment.name = :experimentName and pp.id.startDate <= current_date() and (pp.endDate is null or pp.endDate > current_date()))";
        Query q = this.getSession().createQuery(query).setLong("personId", personId.longValue()).setString("experimentName", experimentName);
        return (VOMSOrgDBPerson)q.uniqueResult();
    }

    @Override
    public VOMSOrgDBPerson findPersonWithValidExperimentParticipationByEmail(String emailAddress, String experimentName) {
        String query = "select p from VOMSOrgDBPerson p join p.participations pp where (lower(p.physicalEmail) = :email or lower(p.email) = :email) and (pp.experiment.name = :experimentName and pp.id.startDate <= current_date() and (pp.endDate is null or pp.endDate > current_date()))";
        Query q = this.getSession().createQuery(query).setString("email", emailAddress).setString("experimentName", experimentName);
        return (VOMSOrgDBPerson)q.uniqueResult();
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonsWithExpiredExperimentParticipationById(List<Long> personIds, String experimentName) {
        return null;
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonsWithExpiredExperimentParticipationByEmail(List<String> emailAddresses, String experimentName) {
        return null;
    }

    @Override
    public VOMSOrgDBPerson findPersonByEmail(String emailAddress) {
        String query = "select p from VOMSOrgDBPerson p join p.participations pp where lower(p.physicalEmail) = :email or lower(p.email) = :email";
        Query q = this.getSession().createQuery(query).setString("email", emailAddress);
        return (VOMSOrgDBPerson)q.uniqueResult();
    }

    @Override
    public VOMSOrgDBPerson findPersonById(Long personId) {
        return (VOMSOrgDBPerson)this.getSession().load(VOMSOrgDBPerson.class, (Serializable)personId);
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonByName(String firstName, String name) {
        return this.findByCriteria(new Criterion[]{Restrictions.eq((String)"firstName", (Object)firstName).ignoreCase(), Restrictions.eq((String)"name", (Object)name).ignoreCase()});
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonBySurname(String surname) {
        return this.findByCriteria(new Criterion[]{Restrictions.eq((String)"name", (Object)surname).ignoreCase()});
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonsWithExpiredExperimentParticipation(String experimentName, List<String> validEmails) {
        String query = "select p from VOMSOrgDBPerson p join p.participations pp where pp.experiment.name = :experimentName and pp.endDate != null  and pp.endDate < current_date() and(lower(p.physicalEmail) in :validEmails or lower(p.email) in :validEmails)";
        Query q = this.getSession().createQuery(query).setString("experimentName", experimentName).setParameterList("validEmails", validEmails);
        return q.list();
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonsWithValidExperimentParticipation(String experimentName) {
        String query = "select p from VOMSOrgDBPerson p join p.participations pp where pp.experiment.name = :experimentName and pp.id.startDate <= current_date() and (pp.endDate is null or pp.endDate > current_date()) and (p.email is not null or p.physicalEmail is not null)";
        Query q = this.getSession().createQuery(query).setString("experimentName", experimentName);
        return q.list();
    }

    @Override
    public Long countPersonsWithValidExperimentParticipation(String experimentName) {
        String query = "select count(*) from VOMSOrgDBPerson p join p.participations pp where pp.experiment.name = :experimentName and pp.id.startDate <= current_date() and (pp.endDate is null or pp.endDate > current_date()) and (p.email is not null or p.physicalEmail is not null)";
        Query q = this.getSession().createQuery(query).setString("experimentName", experimentName);
        return (Long)q.uniqueResult();
    }

    @Override
    public List<VOMSOrgDBPerson> findPersonsWithValidExperimentParticipationByName(String name, String surname, String experimentName) {
        String query = "select p from VOMSOrgDBPerson p join p.participations pp where p.firstName = upper(:name) and p.name  = upper(:surname) and (pp.experiment.name = :experimentName and pp.id.startDate <= current_date() and (pp.endDate is null or pp.endDate > current_date()))";
        Query q = this.getSession().createQuery(query).setString("name", name).setString("surname", surname).setString("experimentName", experimentName);
        return q.list();
    }
}

