/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb.dao;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBSessionFactory;
import org.glite.security.voms.admin.persistence.dao.generic.GenericDAO;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;

public abstract class OrgDBGenericHibernateDAO<T, ID extends Serializable>
implements GenericDAO<T, ID> {
    private Class<T> persistentClass = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    private Session session;

    public OrgDBGenericHibernateDAO() {
        this.getSession().beginTransaction();
    }

    public void setSession(Session s) {
        this.session = s;
    }

    protected Session getSession() {
        if (this.session != null) {
            return this.session;
        }
        if (OrgDBSessionFactory.getSessionFactory().getCurrentSession() != null) {
            return OrgDBSessionFactory.getSessionFactory().getCurrentSession();
        }
        return OrgDBSessionFactory.getSessionFactory().openSession();
    }

    public Class<T> getPersistentClass() {
        return this.persistentClass;
    }

    @Override
    public T findById(ID id, boolean lock) {
        Object entity = lock ? this.getSession().load(this.getPersistentClass(), id, LockMode.UPGRADE) : this.getSession().load(this.getPersistentClass(), id);
        return (T)entity;
    }

    @Override
    public List<T> findAll() {
        return this.findByCriteria(new Criterion[0]);
    }

    @Override
    public List<T> findByExample(T exampleInstance, String ... excludeProperty) {
        Criteria crit = this.getSession().createCriteria(this.getPersistentClass());
        Example example = Example.create(exampleInstance);
        for (String exclude : excludeProperty) {
            example.excludeProperty(exclude);
        }
        crit.add((Criterion)example);
        return crit.list();
    }

    @Override
    public T makePersistent(T entity) {
        this.getSession().saveOrUpdate(entity);
        return entity;
    }

    @Override
    public void makeTransient(T entity) {
        this.getSession().delete(entity);
    }

    @Override
    public void flush() {
        this.getSession().flush();
    }

    @Override
    public void clear() {
        this.getSession().clear();
    }

    protected List<T> findByCriteria(Criterion ... criterion) {
        Criteria crit = this.getSession().createCriteria(this.getPersistentClass());
        for (Criterion c : criterion) {
            crit.add(c);
        }
        return crit.list();
    }
}

