/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration.orgdb;

import java.util.List;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBDAOFactory;
import org.glite.security.voms.admin.integration.orgdb.dao.OrgDBVOMSPersonDAO;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBError;
import org.glite.security.voms.admin.integration.orgdb.database.OrgDBSessionFactory;
import org.glite.security.voms.admin.integration.orgdb.model.VOMSOrgDBPerson;
import org.glite.security.voms.admin.integration.orgdb.strategies.OrgDBMembershipSynchronizationStrategy;
import org.glite.security.voms.admin.integration.orgdb.strategies.OrgDBMissingMembershipRecordStrategy;
import org.glite.security.voms.admin.integration.orgdb.strategies.OrgDbExpiredParticipationStrategy;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrgDBMembershipSynchronizationTask
implements Runnable {
    public static final Logger log = LoggerFactory.getLogger(OrgDBMembershipSynchronizationTask.class);
    protected String experimentName;
    protected OrgDBMissingMembershipRecordStrategy missingMembershipStrategy;
    protected OrgDbExpiredParticipationStrategy expiredParticipationStrategy;
    protected OrgDBMembershipSynchronizationStrategy synchronizationStrategy;

    public OrgDBMembershipSynchronizationTask(String experiment, OrgDBMissingMembershipRecordStrategy invalidMembershipStrategy, OrgDbExpiredParticipationStrategy expiredParticaptionStrategy, OrgDBMembershipSynchronizationStrategy membershipSynchronizationStrategy) {
        this.experimentName = experiment;
        this.missingMembershipStrategy = invalidMembershipStrategy;
        this.expiredParticipationStrategy = expiredParticaptionStrategy;
        this.synchronizationStrategy = membershipSynchronizationStrategy;
    }

    @Override
    public void run() {
        block4: {
            SessionFactory sf = OrgDBSessionFactory.getSessionFactory();
            try {
                OrgDBVOMSPersonDAO dao = OrgDBDAOFactory.instance().getVOMSPersonDAO();
                List allUsers = VOMSUserDAO.instance().findAll();
                for (VOMSUser u : allUsers) {
                    VOMSOrgDBPerson orgDbPerson = dao.findPersonByEmail(u.getEmailAddress());
                    if (orgDbPerson != null) {
                        this.synchronizationStrategy.synchronizeMemberInformation(u, orgDbPerson, this.experimentName);
                        if (orgDbPerson.hasValidParticipationForExperiment(this.experimentName)) continue;
                        this.expiredParticipationStrategy.handleOrgDbExpiredParticipation(u, orgDbPerson, this.experimentName);
                        continue;
                    }
                    log.warn("No OrgDB record found for user {}.", (Object)u);
                    this.missingMembershipStrategy.handleMissingMembershipRecord(u);
                }
                sf.getCurrentSession().getTransaction().commit();
                sf.getCurrentSession().close();
            }
            catch (OrgDBError e) {
                log.error("OrgDB exception caught: {}", (Object)e.getMessage());
                if (!log.isDebugEnabled()) break block4;
                log.error("OrgDB exception caught: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }
}

