/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.integration;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.integration.PluginConfigurator;
import org.glite.security.voms.admin.integration.VOMSPluginConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    public static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    private static PluginManager INSTANCE;
    private Map<String, PluginConfigurator> configuredPluginsMap = new HashMap<String, PluginConfigurator>();

    private PluginManager() {
    }

    public static final PluginManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new PluginManager();
        }
        return INSTANCE;
    }

    public void configurePlugins() {
        log.debug("Configuring external validation plugins.");
        boolean registrationEnabled = VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true);
        if (!registrationEnabled) {
            log.info("Plugin configuration will be skipped since registration is DISABLED for this VO");
            return;
        }
        VOMSConfiguration conf = VOMSConfiguration.instance();
        List<String> activePlugins = conf.getExternalValidators();
        if (activePlugins == null || activePlugins.isEmpty()) {
            log.debug("No external validation plugins found to configure.");
            return;
        }
        for (String pluginName : activePlugins) {
            String pluginConfClassName = conf.getExternalValidatorConfigClass(pluginName);
            if (pluginConfClassName == null || "".equals(pluginConfClassName.trim())) {
                log.error("No configuration class defined for plugin '{}'. Please specify a class using the '{}' property in the service.properties file.");
                continue;
            }
            try {
                Class<?> confClazz = Class.forName(pluginConfClassName);
                PluginConfigurator pluginConfigurator = (PluginConfigurator)confClazz.newInstance();
                pluginConfigurator.setPluginName(pluginName);
                pluginConfigurator.configure();
                this.configuredPluginsMap.put(pluginConfClassName, pluginConfigurator);
            }
            catch (VOMSPluginConfigurationException e) {
                log.error("Error configuring '{}' plugin: {}", (Object)pluginName, (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                log.error("{} plugin configuration ABORTED.", (Object)pluginName);
                continue;
            }
            catch (Exception e) {
                log.error("Cannot instantiate the configuration class '{}' for plugin '{}'", (Object[])new String[]{pluginConfClassName, pluginName});
                log.error(e.getMessage(), (Throwable)e);
                log.error("{} plugin configuration ABORTED.", (Object)pluginName);
                continue;
            }
            log.info("'{}' plugin configured SUCCESSFULLY.", (Object)pluginName);
        }
        log.debug("External validation plugin configuration done.");
    }

    public PluginConfigurator getConfiguredPlugin(String pluginConfigurator) {
        return this.configuredPluginsMap.get(pluginConfigurator);
    }
}

