/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.validation.strategies.impl;

import java.util.List;
import org.glite.security.voms.admin.core.validation.ValidationManager;
import org.glite.security.voms.admin.core.validation.strategies.AUPFailingMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.HandleAUPFailingMembersStrategy;
import org.glite.security.voms.admin.event.EventManager;
import org.glite.security.voms.admin.event.user.SignAUPTaskAssignedEvent;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.glite.security.voms.admin.persistence.dao.generic.AUPDAO;
import org.glite.security.voms.admin.persistence.dao.generic.DAOFactory;
import org.glite.security.voms.admin.persistence.dao.generic.TaskDAO;
import org.glite.security.voms.admin.persistence.dao.hibernate.HibernateDAOFactory;
import org.glite.security.voms.admin.persistence.model.AUP;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.glite.security.voms.admin.persistence.model.task.SignAUPTask;
import org.glite.security.voms.admin.persistence.model.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendAUPFailingMembersStrategy
implements HandleAUPFailingMembersStrategy,
AUPFailingMembersLookupStrategy {
    public static final Logger log = LoggerFactory.getLogger(SuspendAUPFailingMembersStrategy.class);

    @Override
    public List<VOMSUser> findAUPFailingMembers() {
        AUPDAO aupDAO = DAOFactory.instance().getAUPDAO();
        VOMSUserDAO userDAO = VOMSUserDAO.instance();
        return userDAO.findAUPFailingUsers(aupDAO.getVOAUP());
    }

    protected synchronized void handleAUPFailingMember(VOMSUser u) {
        AUPDAO aupDAO = HibernateDAOFactory.instance().getAUPDAO();
        AUP aup = aupDAO.getVOAUP();
        log.debug("Checking user '" + u + "' compliance with '" + aup.getName() + "'");
        TaskDAO taskDAO = DAOFactory.instance().getTaskDAO();
        SignAUPTask pendingSignAUPTask = u.getPendingSignAUPTask(aup);
        if (pendingSignAUPTask == null) {
            SignAUPTask t = taskDAO.createSignAUPTask(aup);
            u.assignTask(t);
            log.debug("Sign aup task assigned to user '{}'", (Object)u);
            EventManager.dispatch(new SignAUPTaskAssignedEvent(u, aup));
        } else {
            if (u.getSuspended().booleanValue()) {
                log.debug("User already suspended. Reason: {}", (Object)u.getSuspensionReason());
                return;
            }
            log.debug("Sign AUP task: {}", (Object)pendingSignAUPTask);
            if (pendingSignAUPTask.getStatus().equals((Object)Task.TaskStatus.EXPIRED)) {
                log.info("Suspending user '" + u + "' that failed to sign AUP in time");
                ValidationManager.instance().suspendUser(u, VOMSUser.SuspensionReason.FAILED_TO_SIGN_AUP);
            }
        }
    }

    @Override
    public void handleAUPFailingMembers(List<VOMSUser> aupFailingMembers) {
        if (aupFailingMembers == null || aupFailingMembers.isEmpty()) {
            return;
        }
        for (VOMSUser u : aupFailingMembers) {
            this.handleAUPFailingMember(u);
        }
    }
}

