/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.validation.strategies.impl;

import java.util.List;
import org.glite.security.voms.admin.core.validation.strategies.HandleExpiringMembersStrategy;
import org.glite.security.voms.admin.notification.ConditionalSendNotificationStrategy;
import org.glite.security.voms.admin.notification.NotificationUtil;
import org.glite.security.voms.admin.notification.TimeIntervalNotificationStrategy;
import org.glite.security.voms.admin.notification.messages.MembershipExpirationWarning;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendWarningAboutExpiringMembersStrategy
implements HandleExpiringMembersStrategy {
    public static final Logger log = LoggerFactory.getLogger(SendWarningAboutExpiringMembersStrategy.class);
    ConditionalSendNotificationStrategy notificationStrategy = new TimeIntervalNotificationStrategy();

    @Override
    public void handleMembersAboutToExpire(List<VOMSUser> expiringMembers) {
        if (log.isDebugEnabled()) {
            log.debug("Handling members about to expire: {}", expiringMembers);
        }
        if (expiringMembers == null | expiringMembers.isEmpty()) {
            return;
        }
        if (this.notificationStrategy.notificationRequired()) {
            log.debug("Sending out notification about expiring VO members.");
            MembershipExpirationWarning m = new MembershipExpirationWarning(expiringMembers);
            m.addRecipients(NotificationUtil.getAdministratorsEmailList());
            this.notificationStrategy.sendNotification(m);
        }
    }
}

