/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.validation.strategies.impl;

import java.util.List;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.validation.AbstractMembershipCheckBehaviour;
import org.glite.security.voms.admin.core.validation.strategies.AUPFailingMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.ExpiredMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.ExpiringMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.HandleAUPFailingMembersStrategy;
import org.glite.security.voms.admin.core.validation.strategies.HandleExpiredMembersStrategy;
import org.glite.security.voms.admin.core.validation.strategies.HandleExpiringMembersStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.DefaultAUPFailingMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.DefaultExpiredMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.DefaultExpiringMembersLookupStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.GracePeriodExpiredMembersStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.IgnoreMembershipEndTimeStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.PreserveExpiredMembersStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.SendWarningAboutExpiringMembersStrategy;
import org.glite.security.voms.admin.core.validation.strategies.impl.SuspendAUPFailingMembersStrategy;
import org.glite.security.voms.admin.persistence.model.VOMSUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultMembershipCheckBehaviour
extends AbstractMembershipCheckBehaviour {
    public static final Logger log = LoggerFactory.getLogger(DefaultMembershipCheckBehaviour.class);
    protected final AUPFailingMembersLookupStrategy aupFMLookupStrategy;
    protected final ExpiredMembersLookupStrategy expiredMembersLookupStrategy;
    protected final ExpiringMembersLookupStrategy expiringMembersLookupStrategy;
    protected final HandleAUPFailingMembersStrategy aupFailingMembersStrategy;
    protected final HandleExpiredMembersStrategy expiredMembersStrategy;
    protected final HandleExpiringMembersStrategy expiringMembersStrategy;

    protected void validateMembershipCheckConfiguration() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        boolean disableMembershipEndTime = conf.getBoolean("voms.disable_membership_end_time", false);
        boolean preserveExpiredMembers = conf.getBoolean("voms.preserve_expired_members", false);
        if (disableMembershipEndTime && preserveExpiredMembers) {
            log.error("The {} and {} configuration properties cannot be true at the same time", (Object[])new String[]{"voms.disable_membership_end_time", "voms.preserve_expired_members"});
            log.warn("Setting {} to false", (Object)"voms.disable_membership_end_time");
            conf.setProperty("voms.disable_membership_end_time", false);
        }
    }

    public DefaultMembershipCheckBehaviour() {
        this.validateMembershipCheckConfiguration();
        VOMSConfiguration conf = VOMSConfiguration.instance();
        this.aupFMLookupStrategy = new DefaultAUPFailingMembersLookupStrategy();
        this.aupFailingMembersStrategy = new SuspendAUPFailingMembersStrategy();
        boolean disableMembershipEndTime = conf.getBoolean("voms.disable_membership_end_time", false);
        boolean preserveExpiredMembers = conf.getBoolean("voms.preserve_expired_members", false);
        int notificationInterval = VOMSConfiguration.instance().getInt("voms.membership.notification_resend_period", 1);
        if (disableMembershipEndTime) {
            IgnoreMembershipEndTimeStrategy s = new IgnoreMembershipEndTimeStrategy();
            log.warn("The membership end time will be IGNORED by the VOMS membership check behaviour as requested by configuration.");
            this.expiredMembersLookupStrategy = s;
            this.expiredMembersStrategy = s;
            this.expiringMembersStrategy = s;
            this.expiringMembersLookupStrategy = s;
        } else if (preserveExpiredMembers) {
            log.warn("Expired members will NOT be suspended as requested. Administrators will be notified of expired members via email.");
            this.expiredMembersStrategy = new PreserveExpiredMembersStrategy(notificationInterval);
            this.expiredMembersLookupStrategy = new DefaultExpiredMembersLookupStrategy();
            this.expiringMembersLookupStrategy = new DefaultExpiringMembersLookupStrategy();
            this.expiringMembersStrategy = new SendWarningAboutExpiringMembersStrategy();
        } else {
            this.expiredMembersLookupStrategy = new DefaultExpiredMembersLookupStrategy();
            this.expiringMembersLookupStrategy = new DefaultExpiringMembersLookupStrategy();
            long gracePeriodInDays = VOMSConfiguration.instance().getLong("voms.membership.expiration_grace_period", 7L);
            if (gracePeriodInDays <= 0L) {
                gracePeriodInDays = 0L;
            }
            log.info("Expired users will be suspended after a grace period of {} days.", (Object)gracePeriodInDays);
            this.expiredMembersStrategy = new GracePeriodExpiredMembersStrategy(gracePeriodInDays, notificationInterval);
            this.expiringMembersStrategy = new SendWarningAboutExpiringMembersStrategy();
        }
    }

    @Override
    public List<VOMSUser> findAUPFailingMembers() {
        return this.aupFMLookupStrategy.findAUPFailingMembers();
    }

    @Override
    public List<VOMSUser> findExpiredMembers() {
        return this.expiredMembersLookupStrategy.findExpiredMembers();
    }

    @Override
    public void handleExpiredMembers(List<VOMSUser> expiredMembers) {
        this.expiredMembersStrategy.handleExpiredMembers(expiredMembers);
    }

    @Override
    public List<VOMSUser> findExpiringMembers() {
        return this.expiringMembersLookupStrategy.findExpiringMembers();
    }

    @Override
    public void handleMembersAboutToExpire(List<VOMSUser> expiringMembers) {
        this.expiringMembersStrategy.handleMembersAboutToExpire(expiringMembers);
    }

    @Override
    public void handleAUPFailingMembers(List<VOMSUser> aupFailingMembers) {
        this.aupFailingMembersStrategy.handleAUPFailingMembers(aupFailingMembers);
    }
}

