/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.core.tasks.DatabaseTransactionTaskWrapper;
import org.glite.security.voms.admin.core.tasks.RegistrationServiceTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VOMSExecutorService {
    public static final long BACKGROUND_TASKS_INITIAL_DELAY = 10L;
    private static final int DEFAULT_POOL_SIZE = 1;
    public static Logger log = LoggerFactory.getLogger(VOMSExecutorService.class);
    private static VOMSExecutorService INSTANCE = null;
    private ScheduledExecutorService executorService;

    private VOMSExecutorService() {
        int threadPoolSize = VOMSConfiguration.instance().getInt("voms.background_tasks.thread_pool_size", 1);
        this.executorService = Executors.newScheduledThreadPool(threadPoolSize);
    }

    public static synchronized void shutdown() {
        if (INSTANCE == null) {
            log.debug("Executor service has not been started and, as such, cannot be shut down");
            return;
        }
        INSTANCE.shutdownNow();
    }

    public static synchronized VOMSExecutorService instance() {
        if (INSTANCE == null) {
            INSTANCE = new VOMSExecutorService();
        }
        return INSTANCE;
    }

    private Long getPeriod(String propertyName, Long defaultPeriod) {
        if (propertyName == null && defaultPeriod != null) {
            return defaultPeriod;
        }
        Long period = VOMSConfiguration.instance().getLong(propertyName, defaultPeriod);
        if (period == null) {
            log.warn("{} not found in configuration!", (Object)propertyName);
        }
        return period;
    }

    public void startBackgroundTask(Runnable task, String periodPropertyName) {
        this.startBackgroundTask(task, periodPropertyName, null);
    }

    public void startBackgroundTask(Runnable task, String periodPropertyName, Long defaultPeriod) {
        boolean registrationEnabled = VOMSConfiguration.instance().getBoolean("voms.registration.enabled", true);
        boolean readOnly = VOMSConfiguration.instance().getBoolean("voms.readonly", false);
        if (readOnly) {
            log.info("Task {} not started since this instance is read-only.", (Object)task.getClass().getSimpleName());
            return;
        }
        if (!registrationEnabled && task instanceof RegistrationServiceTask) {
            log.info("Task {} not started since registration is DISABLED for this VO.", (Object)task.getClass().getSimpleName());
            return;
        }
        Long period = this.getPeriod(periodPropertyName, defaultPeriod);
        if (period == null) {
            log.error("No period specified for task {}. Task will not be started.", (Object)task.getClass().getSimpleName());
            return;
        }
        if (period < 0L) {
            log.info("Task {} will not be started, as requested: {} < 0.", (Object)task.getClass().getSimpleName(), (Object)periodPropertyName);
            return;
        }
        log.info("Scheduling task {} with period: {} seconds", (Object[])new String[]{task.getClass().getSimpleName(), period.toString()});
        this.executorService.scheduleAtFixedRate(new DatabaseTransactionTaskWrapper(task, true), 10L, period, TimeUnit.SECONDS);
    }

    public boolean isShutdown() {
        return this.executorService.isShutdown();
    }

    public boolean isTerminated() {
        return this.executorService.isTerminated();
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executorService.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    protected List<Runnable> shutdownNow() {
        return this.executorService.shutdownNow();
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executorService.submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.executorService.submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.executorService.submit(task);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executorService.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.executorService.schedule(callable, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.executorService.schedule(command, delay, unit);
    }
}

