/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.glite.security.voms.admin.persistence.dao.VOMSUserDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserStatsTask
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(UserStatsTask.class);
    public static final String DEFAULT_USER_STATS_BASE_PATH = "/var/tmp/voms-admin";
    public static final String DEFAULT_USER_STATS_FILENAME = "stats.properties";
    public static final Long DEFAULT_PERIOD_IN_SECONDS = TimeUnit.MINUTES.toSeconds(60L);
    Properties monitoredProperties;

    public UserStatsTask() {
        this.createStatsDir();
        this.monitoredProperties = new Properties();
    }

    void storeProperties() {
        try {
            FileOutputStream fos = new FileOutputStream(this.getStatsFileName());
            this.monitoredProperties.store(fos, null);
            fos.close();
        }
        catch (IOException e) {
            logger.error("Couldn't write user stats file: {}", (Object)e.getMessage(), (Object)e);
            this.createStatsDir();
        }
    }

    String getStatsDirPath() {
        String statsDirPath = VOMSConfiguration.instance().getString("voms.monitoring.user_stats_base_path", DEFAULT_USER_STATS_BASE_PATH);
        String statsDir = String.format("%s/%s", statsDirPath, VOMSConfiguration.instance().getVOName());
        return statsDir;
    }

    String getStatsFileName() {
        return String.format("%s/%s", this.getStatsDirPath(), DEFAULT_USER_STATS_FILENAME);
    }

    void createStatsDir() {
        File statsDirFile = new File(this.getStatsDirPath());
        if (!statsDirFile.exists()) {
            statsDirFile.mkdirs();
        }
    }

    @Override
    public void run() {
        VOMSUserDAO dao = VOMSUserDAO.instance();
        Long expiredUsersCount = dao.countExpiredUsers();
        Long usersCount = dao.countUsers();
        Long suspendedUsersCount = dao.countSuspendedUsers();
        this.monitoredProperties.put("usersCount", usersCount.toString());
        this.monitoredProperties.put("expiredUsersCount", expiredUsersCount.toString());
        this.monitoredProperties.put("suspendUsersCount", suspendedUsersCount.toString());
        this.storeProperties();
    }
}

