/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.core.tasks;

import org.glite.security.voms.admin.core.tasks.BaseTaskWrapper;
import org.glite.security.voms.admin.persistence.HibernateFactory;
import org.glite.security.voms.admin.persistence.error.VOMSDatabaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseTransactionTaskWrapper
extends BaseTaskWrapper {
    public static final Logger log = LoggerFactory.getLogger(DatabaseTransactionTaskWrapper.class);
    boolean doLogging = false;

    public DatabaseTransactionTaskWrapper(Runnable task, boolean logStartAndEnd) {
        super(task);
        this.doLogging = logStartAndEnd;
    }

    @Override
    public void run() {
        try {
            HibernateFactory.getSession();
            HibernateFactory.beginTransaction();
            if (this.doLogging) {
                log.debug("{} task starting...", (Object)this.task.getClass().getSimpleName());
            }
            this.task.run();
            HibernateFactory.commitTransaction();
            HibernateFactory.closeSession();
            if (this.doLogging) {
                log.debug("{} task done.", (Object)this.task.getClass().getSimpleName());
            }
        }
        catch (VOMSDatabaseException e) {
            log.error("Database exception caught while executing {} task: {}", (Object[])new String[]{this.task.getClass().getSimpleName(), e.getMessage()});
            log.error(e.getMessage(), (Throwable)e);
            log.error("Swallowing the exception hoping it's a temporary failure.");
        }
        catch (Throwable t) {
            log.error("An unexpected exception was caught while executing task {}", (Object)this.task.getClass().getSimpleName());
            log.error(t.getMessage(), t);
        }
    }
}

