/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.ssl.PKCS8Key;
import org.glite.security.voms.admin.configuration.VOMSConfigurationException;
import org.glite.security.voms.admin.error.VOMSException;
import org.glite.security.voms.admin.operations.VOMSPermission;
import org.glite.security.voms.admin.util.DNUtil;
import org.glite.security.voms.admin.util.SysconfigUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VOMSConfiguration {
    private static volatile VOMSConfiguration instance = null;
    private CompositeConfiguration config;
    private ServletContext context;
    Logger log = LoggerFactory.getLogger(VOMSConfiguration.class);
    private X509Certificate serviceCertificate;
    private PrivateKey servicePrivateKey;

    public static synchronized VOMSConfiguration load(ServletContext context) {
        if (instance != null) {
            throw new VOMSConfigurationException("VOMS configuration already loaded!");
        }
        instance = new VOMSConfiguration(context);
        return instance;
    }

    public static synchronized void dispose() {
        if (instance != null) {
            instance.clear();
            instance = null;
        }
    }

    public static VOMSConfiguration instance() {
        if (instance == null) {
            throw new VOMSConfigurationException("VOMS configuration not loaded! Use the load method to load it.");
        }
        return instance;
    }

    private void loadConfDir() {
        this.loadSysconfig();
        if (this.config.getString("CONF_DIR") == null) {
            this.log.warn("{} undefined in VOMS Admin sysconfig.", (Object)"CONF_DIR");
            this.log.warn("Setting default value assuming EMI packaging: {}", (Object)"/etc/voms-admin");
            this.config.setProperty("CONF_DIR", (Object)"/etc/voms-admin");
        }
        if (this.context != null && this.context.getInitParameter("CONF_DIR") != null) {
            this.log.info("Setting {} from context: {}", (Object)"CONF_DIR", (Object)this.context.getInitParameter("CONF_DIR"));
            this.config.setProperty("CONF_DIR", (Object)this.context.getInitParameter("CONF_DIR"));
        }
    }

    private VOMSConfiguration(ServletContext ctxt) {
        this.context = ctxt;
        this.config = new CompositeConfiguration();
        this.loadVersionProperties();
        this.loadConfDir();
        this.loadHostAndPort();
        if (this.context != null) {
            this.context = ctxt;
            this.loadVOName();
            if (!this.getVOName().equals("siblings")) {
                this.loadServiceProperties();
                if (this.getBoolean("voms.aa.activate_saml_endpoint", false)) {
                    this.loadServiceCredentials();
                }
            }
        } else {
            this.config.addConfiguration((Configuration)new SystemConfiguration());
        }
        this.log.debug("VOMS-Admin configuration loaded!");
    }

    private void loadHostAndPort() {
        if (this.context != null) {
            this.config.setProperty("voms.port", (Object)this.context.getInitParameter("PORT"));
            this.config.setProperty("voms.hostname", (Object)this.context.getInitParameter("HOST"));
        }
    }

    public void addProperty(String arg0, Object arg1) {
        this.config.addProperty(arg0, arg1);
    }

    public void clear() {
        this.config.clear();
    }

    public void clearProperty(String arg0) {
        this.config.clearProperty(arg0);
    }

    public boolean containsKey(String arg0) {
        return this.config.containsKey(arg0);
    }

    public BigDecimal getBigDecimal(String arg0) {
        return this.config.getBigDecimal(arg0);
    }

    public BigDecimal getBigDecimal(String arg0, BigDecimal arg1) {
        return this.config.getBigDecimal(arg0, arg1);
    }

    public BigInteger getBigInteger(String arg0) {
        return this.config.getBigInteger(arg0);
    }

    public BigInteger getBigInteger(String arg0, BigInteger arg1) {
        return this.config.getBigInteger(arg0, arg1);
    }

    public boolean getBoolean(String arg0) {
        return this.config.getBoolean(arg0);
    }

    public boolean getBoolean(String arg0, boolean arg1) {
        return this.config.getBoolean(arg0, arg1);
    }

    public Boolean getBoolean(String arg0, Boolean arg1) {
        return this.config.getBoolean(arg0, arg1);
    }

    public byte getByte(String arg0) {
        return this.config.getByte(arg0);
    }

    public byte getByte(String arg0, byte arg1) {
        return this.config.getByte(arg0, arg1);
    }

    public Byte getByte(String arg0, Byte arg1) {
        return this.config.getByte(arg0, arg1);
    }

    public String getCustomizationPageAbsolutePath(String pageName) {
        String basePath = this.getCustomizedContentPath() + "/" + pageName;
        File f = new File(basePath);
        if (f.exists() && f.canRead()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public String getConfigurationDirectoryPath() {
        String path = this.config.getString("CONF_DIR") + "/" + this.getVOName();
        return path;
    }

    private String getCustomizedContentPath() {
        String pathName = this.getConfigurationDirectoryPath() + "/customized-content/";
        return pathName;
    }

    public Properties getDatabaseProperties() {
        String propFileName = this.getConfigurationDirectoryPath() + "/database.properties";
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(propFileName));
        }
        catch (IOException e) {
            this.log.error("Error loading database properties: " + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error loading database properties: " + e.getMessage(), e);
        }
        return props;
    }

    public String getDefaultVOAUPURL() {
        return String.format("file://%s/vo-aup.txt", this.getConfigurationDirectoryPath());
    }

    public double getDouble(String arg0) {
        return this.config.getDouble(arg0);
    }

    public double getDouble(String arg0, double arg1) {
        return this.config.getDouble(arg0, arg1);
    }

    public Double getDouble(String arg0, Double arg1) {
        return this.config.getDouble(arg0, arg1);
    }

    private InputStream getExternalLogbackConfiguration() throws FileNotFoundException {
        String path = this.getConfigurationDirectoryPath() + "/logback.runtime.xml";
        File f = new File(path);
        if (!f.exists()) {
            this.log.warn("External logging configuration not found at path '" + path + "'... ");
        }
        if (!f.canRead()) {
            this.log.warn("External logging configuration is not readable: '" + path + "'... ");
        }
        return new FileInputStream(f);
    }

    public float getFloat(String arg0) {
        return this.config.getFloat(arg0);
    }

    public float getFloat(String arg0, float arg1) {
        return this.config.getFloat(arg0, arg1);
    }

    public Float getFloat(String arg0, Float arg1) {
        return this.config.getFloat(arg0, arg1);
    }

    public int getInt(String arg0) {
        return this.config.getInt(arg0);
    }

    public int getInt(String arg0, int arg1) {
        return this.config.getInt(arg0, arg1);
    }

    public Integer getInteger(String arg0, Integer arg1) {
        return this.config.getInteger(arg0, arg1);
    }

    public Iterator getKeys() {
        return this.config.getKeys();
    }

    public Iterator getKeys(String arg0) {
        return this.config.getKeys(arg0);
    }

    public List getList(String arg0) {
        return this.config.getList(arg0);
    }

    public List getList(String arg0, List arg1) {
        return this.config.getList(arg0, arg1);
    }

    public List getLocallyConfiguredVOs() {
        String configDirPath = this.getString("CONF_DIR");
        if (configDirPath == null) {
            throw new VOMSConfigurationException("No value found for CONF_DIR!");
        }
        ArrayList<String> voList = new ArrayList<String>();
        File configDir = new File(configDirPath);
        if (!configDir.exists()) {
            throw new VOMSConfigurationException("Voms configuration directory does not exist");
        }
        File[] filez = configDir.listFiles();
        if (filez != null) {
            for (int i = 0; i < filez.length; ++i) {
                if (!filez[i].isDirectory()) continue;
                this.log.debug("Found vo: " + filez[i].getName());
                voList.add(filez[i].getName());
            }
        }
        return voList;
    }

    public long getLong(String arg0) {
        return this.config.getLong(arg0);
    }

    public long getLong(String arg0, long arg1) {
        return this.config.getLong(arg0, arg1);
    }

    public Long getLong(String arg0, Long arg1) {
        return this.config.getLong(arg0, arg1);
    }

    public Properties getProperties(String arg0) {
        return this.config.getProperties(arg0);
    }

    public Object getProperty(String arg0) {
        return this.config.getProperty(arg0);
    }

    public X509Certificate getServiceCertificate() {
        return this.serviceCertificate;
    }

    public PrivateKey getServicePrivateKey() {
        return this.servicePrivateKey;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public short getShort(String arg0) {
        return this.config.getShort(arg0);
    }

    public short getShort(String arg0, short arg1) {
        return this.config.getShort(arg0, arg1);
    }

    public Short getShort(String arg0, Short arg1) {
        return this.config.getShort(arg0, arg1);
    }

    public String getString(String arg0) {
        return this.config.getString(arg0);
    }

    public String getString(String arg0, String arg1) {
        return this.config.getString(arg0, arg1);
    }

    public String[] getStringArray(String arg0) {
        return this.config.getStringArray(arg0);
    }

    public String getVomsesConfigurationString() {
        if (this.getString("vomses.configuration") == null) {
            String vomsesConfString = this.loadVomsesConfigurationString();
            this.setProperty("vomses.configuration", vomsesConfString);
        }
        return this.getString("vomses.configuration");
    }

    private String getVomsServicePropertiesFileName() {
        String fileName = this.getConfigurationDirectoryPath() + "/service.properties";
        return fileName;
    }

    public String getVOName() {
        return this.getString("voms.vo.name");
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    private void loadServiceCredentials() {
        CertificateFactory certificateFactory;
        FileInputStream certificateInputStream;
        String certificateFileName = this.getString("voms.aa.certificate", "/etc/grid-security/hostcert.pem");
        String privateKeyFileName = this.getString("voms.aa.key", "/etc/grid-security/hostkey.pem");
        this.log.info("Loading credentials for VOMS Attribute authority from:" + certificateFileName + "," + privateKeyFileName);
        try {
            certificateInputStream = new FileInputStream(certificateFileName);
        }
        catch (FileNotFoundException e) {
            this.log.error("Error loading service credentials: " + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error loading service credentials: " + e.getMessage(), e);
        }
        try {
            certificateFactory = CertificateFactory.getInstance("X509", "BC");
        }
        catch (CertificateException e) {
            this.log.error("Error instantiating X509 certificate factory: " + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error instantiating X509 certificate factory: " + e.getMessage(), e);
        }
        catch (NoSuchProviderException e) {
            throw new VOMSException("Error instantiating X509 certificate factory: " + e.getMessage(), e);
        }
        try {
            this.serviceCertificate = (X509Certificate)certificateFactory.generateCertificate(certificateInputStream);
        }
        catch (CertificateException e) {
            this.log.error("Error generating X509 certificate from input stream: " + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error generating X509 certificate from input stream: " + e.getMessage(), e);
        }
        try {
            ((InputStream)certificateInputStream).close();
        }
        catch (IOException e) {
            this.log.error("Error closing certificate input stream:" + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error closing certificate input stream:" + e.getMessage(), e);
        }
        this.log.info("SAML service credential's DN: " + DNUtil.getOpenSSLSubject(this.serviceCertificate.getSubjectX500Principal()));
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(privateKeyFileName);
        }
        catch (FileNotFoundException e) {
            this.log.error("Error opening private key file:" + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error opening private key file:" + e.getMessage(), e);
        }
        PKCS8Key pkcs8 = null;
        try {
            pkcs8 = new PKCS8Key((InputStream)fileInputStream, "".toCharArray());
        }
        catch (GeneralSecurityException e) {
            this.log.error("Error parsing private key from input stream:" + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error parsing private key from input stream:" + e.getMessage(), e);
        }
        catch (IOException e) {
            this.log.error("Error opening private key file:" + e.getMessage(), (Throwable)e);
            throw new VOMSException("Error opening private key file:" + e.getMessage(), e);
        }
        this.servicePrivateKey = pkcs8.getPrivateKey();
    }

    public void loadServiceProperties() {
        String fileName = this.getVomsServicePropertiesFileName();
        try {
            PropertiesConfiguration vomsServiceProperties = new PropertiesConfiguration(this.getVomsServicePropertiesFileName());
            this.config.addConfiguration((Configuration)vomsServiceProperties);
        }
        catch (ConfigurationException e) {
            this.log.error("Error loading service properties from " + fileName);
            if (this.log.isDebugEnabled()) {
                this.log.error(e.getMessage(), (Throwable)e);
            }
            throw new VOMSConfigurationException("Error loading service properties from " + fileName, e);
        }
        this.log.debug("VOMS Admin service properties loaded!");
    }

    private void loadSysconfig() {
        String sysconfigFilePath = "/etc/sysconfig/voms-admin";
        try {
            sysconfigFilePath = SysconfigUtil.getSysconfigFilePath();
            PropertiesConfiguration sysconf = new PropertiesConfiguration(sysconfigFilePath);
            this.config.addConfiguration((Configuration)sysconf);
            this.log.debug("Loaded sysconfig from: {}", (Object)sysconfigFilePath);
        }
        catch (ConfigurationException e) {
            this.log.error("Error parsing VOMS Admin system configuration file " + sysconfigFilePath);
            throw new VOMSConfigurationException("Error parsing VOMS Admin system configuration file /etc/sysconfig/voms-admin", e);
        }
    }

    private void loadVersionProperties() {
        InputStream versionPropStream = this.getClass().getClassLoader().getResourceAsStream("version.properties");
        PropertiesConfiguration versionProperties = new PropertiesConfiguration();
        try {
            versionProperties.load(versionPropStream);
            this.config.addConfiguration((Configuration)versionProperties);
        }
        catch (ConfigurationException e) {
            this.log.error("Error configuring version properties:" + e.getMessage(), (Throwable)e);
            throw new VOMSConfigurationException("Error configuring version properties!", e);
        }
    }

    private String loadLSCConfigurationString() {
        String lscConfFileName = this.getConfigurationDirectoryPath() + "/lsc";
        try {
            String lscConf = FileUtils.readFileToString((File)new File(lscConfFileName));
            return lscConf;
        }
        catch (IOException e) {
            this.log.error("Error loading LSC configuration file:" + e.getMessage(), (Throwable)e);
            throw new VOMSException(e.getMessage(), e);
        }
    }

    private String loadVomsesConfigurationString() {
        String vomsesConfFileName = this.getConfigurationDirectoryPath() + "/vomses";
        try {
            String vomsesConf = FileUtils.readFileToString((File)new File(vomsesConfFileName));
            return vomsesConf;
        }
        catch (IOException e) {
            this.log.error("Error loading vomses configuration file:" + e.getMessage(), (Throwable)e);
            throw new VOMSException(e.getMessage(), e);
        }
    }

    private void loadVOName() {
        SystemConfiguration systemConfig = new SystemConfiguration();
        if (!this.config.containsKey("VO_NAME")) {
            if (this.context.getInitParameter("VO_NAME") != null) {
                this.log.debug("Setting VO name from init parameter: {}", (Object)this.context.getInitParameter("VO_NAME"));
                this.config.setProperty("voms.vo.name", (Object)this.context.getInitParameter("VO_NAME"));
            }
            if (!this.config.containsKey("voms.vo.name")) {
                throw new VOMSConfigurationException("VO_NAME property not found!");
            }
        } else {
            this.config.setProperty("voms.vo.name", this.config.getProperty("VO_NAME"));
        }
    }

    public boolean pageHasCustomization(String pageName) {
        String basePath = this.getCustomizedContentPath() + "/" + pageName;
        File f = new File(basePath);
        return f.exists() && f.canRead();
    }

    public void setProperty(String arg0, Object arg1) {
        this.config.setProperty(arg0, arg1);
    }

    public Configuration subset(String arg0) {
        return this.config.subset(arg0);
    }

    public List<String> getExternalValidators() {
        return this.config.getList("voms.external-validators");
    }

    public String getExternalValidatorConfigClass(String pluginName) {
        String configClassPropertyName = String.format("%s.%s.%s", "voms.ext", pluginName, "configClass");
        return this.config.getString(configClassPropertyName);
    }

    public String getExternalValidatorProperty(String pluginName, String pluginPropertyName, String defaultValue) {
        String propertyName = String.format("%s.%s.%s", "voms.ext", pluginName, pluginPropertyName);
        return this.config.getString(propertyName, defaultValue);
    }

    public String getExternalValidatorProperty(String pluginName, String pluginPropertyName) {
        String propertyName = String.format("%s.%s.%s", "voms.ext", pluginName, pluginPropertyName);
        return this.config.getString(propertyName);
    }

    public void setRegistrationType(String registrationType) {
        this.config.setProperty("___voms.regitration.type", (Object)registrationType);
    }

    public String getRegistrationType() {
        return this.config.getString("___voms.regitration.type", "default");
    }

    public VOMSPermission getUnauthenticatedClientPermissionMask() {
        String unauthenticatedClientPermMask = this.getString("voms.unauthenticated_client_permission_mask", "CONTAINER_READ|MEMBERSHIP_READ");
        VOMSPermission permMask = null;
        try {
            permMask = VOMSPermission.fromString(unauthenticatedClientPermMask);
        }
        catch (IllegalArgumentException e) {
            this.log.error("Error parsing user set permission mask for unauthenticated client: '" + unauthenticatedClientPermMask + "'");
            this.log.error(e.getMessage());
            permMask = VOMSPermission.getContainerReadPermission().setMembershipReadPermission();
        }
        return permMask;
    }

    public String getServiceHostname() {
        return this.config.getString("voms.hostname", "localhost");
    }

    public int getExpiringUsersWarningInterval() {
        Integer i;
        String warningPeriodInDays = VOMSConfiguration.instance().getString("voms.membership.expiration_warning_period", "15");
        try {
            i = Integer.parseInt(warningPeriodInDays);
        }
        catch (NumberFormatException e) {
            this.log.error("Error converting {} to an integer. The {} property should contain a positive integer! Using the default value instead.", (Object)warningPeriodInDays);
            return Integer.parseInt("15");
        }
        if (i <= 0) {
            this.log.warn("Negative warning period set for the property {}. Using the default value instead.", (Object)"voms.membership.expiration_warning_period");
            return Integer.parseInt("15");
        }
        return i;
    }

    public String getLSCConfiguration() {
        return this.loadLSCConfigurationString();
    }

    public void dump(PrintStream stream) {
        for (int i = 0; i < this.config.getNumberOfConfigurations(); ++i) {
            ConfigurationUtils.dump((Configuration)this.config.getConfiguration(i), (PrintStream)stream);
        }
    }
}

