/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.voms.admin.apiv2;

import com.opensymphony.xwork2.validator.annotations.EmailValidator;
import com.opensymphony.xwork2.validator.annotations.RegexFieldValidator;
import com.opensymphony.xwork2.validator.annotations.RequiredStringValidator;
import com.opensymphony.xwork2.validator.annotations.ValidatorType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.glite.security.voms.admin.apiv2.CertificateJSON;
import org.glite.security.voms.admin.persistence.model.Certificate;
import org.glite.security.voms.admin.persistence.model.VOMSUser;

public class VOMSUserJSON {
    private static final long serialVersionUID = 1L;
    Long id;
    String name;
    String surname;
    String institution;
    String address;
    String phoneNumber;
    String emailAddress;
    Date creationTime;
    Date endTime;
    Boolean suspended = false;
    VOMSUser.SuspensionReason suspensionReasonCode;
    String suspensionReason;
    List<CertificateJSON> certificates;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a name for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The name field contains illegal characters!", expression="^[^<>&=;]*$")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a family name for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The family name contains illegal characters!", expression="^[^<>&=;]*$")
    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide an institution for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The institution contains illegal characters!", expression="^[^<>&=;]*$")
    public String getInstitution() {
        return this.institution;
    }

    public void setInstitution(String institution) {
        this.institution = institution;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide an address for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The address contains illegal characters!", expression="^[^<>&=;]*$")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide a phone number for the user.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The phone number contains illegal characters!", expression="^[^<>&=;]*$")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    @RequiredStringValidator(type=ValidatorType.FIELD, message="Please provide an email address for the user.")
    @EmailValidator(type=ValidatorType.FIELD, message="Please enter a valid email address.")
    @RegexFieldValidator(type=ValidatorType.FIELD, message="The email address contains illegal characters!", expression="^[^<>&=;]*$")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public VOMSUser.SuspensionReason getSuspensionReasonCode() {
        return this.suspensionReasonCode;
    }

    public void setSuspensionReasonCode(VOMSUser.SuspensionReason suspensionReasonCode) {
        this.suspensionReasonCode = suspensionReasonCode;
    }

    public String getSuspensionReason() {
        return this.suspensionReason;
    }

    public void setSuspensionReason(String suspensionReason) {
        this.suspensionReason = suspensionReason;
    }

    public List<CertificateJSON> getCertificates() {
        return this.certificates;
    }

    public void setCertificates(List<CertificateJSON> certificates) {
        this.certificates = certificates;
    }

    public static VOMSUserJSON fromVOMSUser(VOMSUser user) {
        VOMSUserJSON u = new VOMSUserJSON();
        u.setId(user.getId());
        u.setName(user.getName());
        u.setSurname(user.getSurname());
        u.setAddress(user.getAddress());
        u.setPhoneNumber(user.getPhoneNumber());
        u.setInstitution(user.getInstitution());
        u.setSuspended(user.getSuspended());
        u.setSuspensionReason(user.getSuspensionReason());
        u.setSuspensionReasonCode(user.getSuspensionReasonCode());
        u.setEmailAddress(user.getEmailAddress());
        u.setCreationTime(user.getCreationTime());
        u.setEndTime(user.getEndTime());
        ArrayList<CertificateJSON> certs = new ArrayList<CertificateJSON>();
        for (Certificate c : user.getCertificates()) {
            certs.add(CertificateJSON.fromCertificate(c));
        }
        u.setCertificates(certs);
        return u;
    }
}

