/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.x509;

import it.infn.cnaf.voms.x509.VOMSResponseFragment;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.glite.security.voms.admin.error.VOMSException;
import org.opensaml.xml.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class VOMSResponseFactory {
    private static final Logger log = LoggerFactory.getLogger(VOMSResponseFactory.class);
    private static VOMSResponseFactory instance = null;
    protected DocumentBuilder docBuilder;

    private VOMSResponseFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setNamespaceAware(false);
        factory.setValidating(false);
        try {
            this.docBuilder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Error configuring DOM document builder.");
            if (log.isDebugEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            throw new VOMSException(e);
        }
    }

    public static VOMSResponseFactory instance() {
        if (instance == null) {
            instance = new VOMSResponseFactory();
        }
        return instance;
    }

    public Document buildResponse(byte[] acBytes) {
        assert (acBytes != null && acBytes.length != 0) : "Cannot build a response for a null AC!";
        Document response = this.docBuilder.newDocument();
        VOMSResponseFragment frag = new VOMSResponseFragment(response);
        frag.buildACElement(Base64.encodeBytes((byte[])acBytes));
        response.appendChild(frag.getFragment());
        return response;
    }

    public Document buildErrorResponse(String vomsErrorCode, String errorMessage) {
        assert (errorMessage != null) : "Cannot build a response for a null errorMessage!";
        Document response = this.docBuilder.newDocument();
        VOMSResponseFragment frag = new VOMSResponseFragment(response);
        frag.buildErrorElement(vomsErrorCode, errorMessage);
        response.appendChild(frag.getFragment());
        return response;
    }
}

