/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.test.saml_client;

import it.infn.cnaf.voms.saml.axis_skeletons.AttributeAuthorityPortType;
import it.infn.cnaf.voms.test.saml_client.SAMLTestUtils;
import java.rmi.RemoteException;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.glite.security.voms.User;
import org.glite.security.voms.VOMSException;
import org.glite.security.voms.service.admin.VOMSAdmin;
import org.glite.security.voms.service.attributes.VOMSAttributes;
import org.opensaml.DefaultBootstrap;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.XMLObject;

public class SAMLEndpointTest
extends TestCase {
    public static final String DEFAULT_HOST = "localhost";
    public static final String DEFAULT_VO = "mysql";
    public static final String DEFAULT_DN = "/C=IT/O=INFN/OU=Personal Certificate/L=CNAF/CN=Andrea Ceccanti";
    public static final String DEFAULT_CA = "/C=IT/O=INFN/CN=INFN CA";
    public static final String DEFAULT_EMAIL = "andrea.ceccanti@cnaf.infn.it";
    static String host = System.getProperty("samltest.host", "localhost");
    static String vo = System.getProperty("samltest.vo", "mysql");
    static String dn = System.getProperty("samltest.user_dn", "/C=IT/O=INFN/OU=Personal Certificate/L=CNAF/CN=Andrea Ceccanti");
    static String ca = System.getProperty("samltest.user_ca", "/C=IT/O=INFN/CN=INFN CA");
    static String email = System.getProperty("samltest.user_email", "andrea.ceccanti@cnaf.infn.it");
    static boolean verbose = Boolean.parseBoolean(System.getProperty("samltest.verbose", "true"));
    static AttributeAuthorityPortType samlEndpoint = null;
    static VOMSAdmin adminEndpoint = null;
    static VOMSAttributes attributesEndpoint = null;
    static String USER_NOT_FOUND_MESSAGE = "User identified by '%s' not found!";

    protected boolean hasStatusCode(Response r, String statusCode) {
        String responseCode = r.getStatus().getStatusCode().getValue();
        return statusCode.equals(responseCode);
    }

    protected boolean hasStatusMessage(Response r, String message) {
        String statusMessage = r.getStatus().getStatusMessage().getMessage();
        return message.equals(statusMessage);
    }

    protected Response doQuery(AttributeQuery q) throws Exception {
        if (verbose) {
            System.out.println("Attribute query: ");
            SAMLTestUtils.printXMLObject((XMLObject)q);
        }
        Response r = samlEndpoint.attributeQuery(q);
        if (verbose) {
            System.out.println("Response: ");
            SAMLTestUtils.printXMLObject((XMLObject)r);
        }
        return r;
    }

    public void testUserNotInVOFailure() throws Exception {
        Response r = this.doQuery(SAMLTestUtils.buildAttributeQuery(dn, vo));
        SAMLEndpointTest.assertTrue((boolean)this.hasStatusCode(r, "urn:oasis:names:tc:SAML:2.0:status:Responder"));
        SAMLEndpointTest.assertTrue((boolean)this.hasStatusMessage(r, String.format(USER_NOT_FOUND_MESSAGE, dn)));
    }

    public void testEmptyQuery() throws Exception {
        this.createTestUser();
        Response r = this.doQuery(SAMLTestUtils.buildAttributeQuery(dn, vo));
        SAMLEndpointTest.assertTrue((boolean)this.hasStatusCode(r, "urn:oasis:names:tc:SAML:2.0:status:Success"));
        this.dropTestUser();
    }

    protected void createTestUser() throws VOMSException, RemoteException {
        User u = new User();
        u.setDN(dn);
        u.setCA(ca);
        u.setMail(email);
        adminEndpoint.createUser(u);
    }

    protected void dropTestUser() throws VOMSException, RemoteException {
        adminEndpoint.deleteUser(dn, ca);
    }

    public static Test suite() {
        return new TestSetup((Test)new TestSuite(SAMLEndpointTest.class)){

            protected void setUp() throws Exception {
                DefaultBootstrap.bootstrap();
                samlEndpoint = SAMLTestUtils.getVOMSSAMLService(host, vo);
                adminEndpoint = SAMLTestUtils.getVOMSAdminService(host, vo);
                attributesEndpoint = SAMLTestUtils.getVOMSAttributesService(host, vo);
            }
        };
    }
}

