/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml.axis_skeletons;

import it.infn.cnaf.voms.saml.SAMLAssertionFactory;
import it.infn.cnaf.voms.saml.SAMLResponseFactory;
import it.infn.cnaf.voms.saml.VOMSSAMLService;
import it.infn.cnaf.voms.saml.axis_skeletons.AttributeAuthorityPortType;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import org.apache.axis.MessageContext;
import org.apache.axis.transport.http.HTTPConstants;
import org.glite.security.voms.admin.configuration.VOMSConfiguration;
import org.opensaml.saml2.core.AttributeQuery;
import org.opensaml.saml2.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeAuthoritySoapBindingImpl
implements AttributeAuthorityPortType {
    private static Logger logger = LoggerFactory.getLogger(AttributeAuthoritySoapBindingImpl.class);
    private VOMSSAMLService vOMSSAMLService;

    public AttributeAuthoritySoapBindingImpl() {
        VOMSConfiguration conf = VOMSConfiguration.instance();
        if (conf.getBoolean("voms.aa.activate_saml_endpoint", false)) {
            SAMLAssertionFactory sAMLAssertionFactory = new SAMLAssertionFactory(conf.getServiceCertificate(), conf.getServicePrivateKey());
            SAMLResponseFactory sAMLResponseFactory = new SAMLResponseFactory(conf.getServiceCertificate().getSubjectX500Principal());
            this.vOMSSAMLService = new VOMSSAMLService(sAMLAssertionFactory, sAMLResponseFactory, conf.getInt("voms.saml.max_assertion_lifetime", 720));
        }
    }

    @Override
    public Response attributeQuery(AttributeQuery attributeQuery) throws RemoteException {
        if (!VOMSConfiguration.instance().getBoolean("voms.aa.activate_saml_endpoint", false)) {
            throw new RemoteException("SAML attribute authority is currently disabled on this VOMS Admin instance.");
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)MessageContext.getCurrentContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
        return this.vOMSSAMLService.attributeQuery(attributeQuery, httpServletRequest);
    }
}

