/*
 * Decompiled with CFR 0.152.
 */
package it.infn.cnaf.voms.saml.axis_serializers;

import java.io.IOException;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.wsdl.fromJava.Types;
import org.opensaml.Configuration;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class Serializer
implements org.apache.axis.encoding.Serializer {
    static Logger logger = LoggerFactory.getLogger(Serializer.class);

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        try {
            Signature signature;
            Assertion assertion;
            Response response;
            List assertions;
            if (!(value instanceof XMLObject)) {
                throw new IOException("Can't serialize a " + value.getClass().getName() + ", " + XMLObject.class + "expected.");
            }
            XMLObject xmlObject = (XMLObject)value;
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(xmlObject);
            Element element = marshaller.marshall(xmlObject);
            if (value instanceof Response && (assertions = (response = (Response)value).getAssertions()).size() > 0 && (assertion = (Assertion)assertions.get(0)) != null && (signature = assertion.getSignature()) != null) {
                Signer.signObject((Signature)signature);
            }
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    element.setAttributeNS(attributes.getURI(i), attributes.getQName(i), attributes.getValue(i));
                }
            }
            context.setWriteXMLType(null);
            context.writeDOMElement(element);
        }
        catch (Exception exception) {
            throw new IOException("Error serializing " + value.getClass().getName() + " : " + exception.getClass().getName());
        }
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        Element complexType = types.createElement("complexType");
        return complexType;
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }
}

